/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.db.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.anotheria.db.service.BasePersistenceServiceJDBCImpl;
import net.anotheria.db.util.JDBCUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBUtil
extends BasePersistenceServiceJDBCImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DBUtil.class.getName());
    public static final String DMD_F_TABLE_NAME = "TABLE_NAME";
    private static DBUtil INSTANCE;

    private DBUtil() {
        this(null);
    }

    private DBUtil(String configName) {
        super(configName);
    }

    public static synchronized DBUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBUtil();
        }
        return INSTANCE;
    }

    public static DBUtil getInstance(String configFile) {
        return new DBUtil(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTables() {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            st = conn.createStatement();
            DatabaseMetaData dmd = conn.getMetaData();
            rs = dmd.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next() && rs.getString(DMD_F_TABLE_NAME) != null) {
                this.dropTable(conn, rs.getString(DMD_F_TABLE_NAME), true);
            }
        }
        catch (SQLException e) {
            try {
                String message = "removeAllTables() fail.";
                LOGGER.warn(message, (Throwable)e);
                new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(rs);
                JDBCUtil.release(st);
                JDBCUtil.release(conn);
                throw throwable;
            }
            JDBCUtil.release(rs);
            JDBCUtil.release(st);
            JDBCUtil.release(conn);
        }
        JDBCUtil.release(rs);
        JDBCUtil.release(st);
        JDBCUtil.release(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection conn, String tableName, boolean isCascadeDrop) {
        Statement st = null;
        try {
            st = conn.createStatement();
            String dropSQL = "DROP TABLE IF EXISTS " + tableName;
            if (isCascadeDrop) {
                dropSQL = dropSQL + " CASCADE";
            }
            st.executeUpdate(dropSQL);
        }
        catch (SQLException e) {
            String message = "dropTable(conn, " + tableName + "," + isCascadeDrop + ") fail.";
            LOGGER.warn(message, (Throwable)e);
        }
        finally {
            JDBCUtil.release(st);
        }
    }
}

