/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.db.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JDBCUtil.class.getName());

    private JDBCUtil() {
        throw new IllegalAccessError("Can't instantiate utility class.");
    }

    public static void close(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("close(" + conn + ") fail.", (Throwable)e);
        }
    }

    public static void close(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("close(" + st + ") fail.", (Throwable)e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("close(" + rs + ") fail.", (Throwable)e);
        }
    }

    public static void release(Connection conn) {
        JDBCUtil.close(conn);
    }

    public static void release(Statement st) {
        JDBCUtil.close(st);
    }

    public static void release(ResultSet rs) {
        JDBCUtil.close(rs);
    }

    public static void rollback(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.rollback();
            }
        }
        catch (SQLException sqle) {
            LOGGER.warn("rollback(java.sql.Connection) rollback fail.", (Throwable)sqle);
        }
    }
}

