package net.anotheria.asg.generator;

import net.anotheria.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * A java class generated by the ASG.
 *
 * @author lrosenberg
 * @version $Id: $Id
 */
public class GeneratedClass extends GeneratedArtefact{

	/**
	 * List of imports.
	 */
	private List<String> imports;
	/**
	 * Lists of implemented interfaces.
	 */
	private List<String> interfaces;
	/**
	 * Lists of annotations.
	 */
	private List<String> annotations;
	
	/**
	 * The body of the class.
	 */
	private StringBuilder body;
	
	/**
	 * The name of the parent class for 'extends' keyword.
	 */
	private ClassDef parent;
	
	/**
	 * The generic of the class.
	 */
	private String generic;
	
	/**
	 * The packagename.
	 */
	private String packageName;
	
	/**
	 * The comment of the type.
	 */
	private String typeComment;
	/**
	 * The comment of the class.
	 */
	private String clazzComment;
	
	/**
	 * The type of class. Can be a class or interface.
	 */
	private TypeOfClass type = TypeOfClass.getDefault();
	
	/**
	 * True if the class needs a logger.
	 */
	private boolean generateLogger = false;
	/**
	 * True if the class is an abstract class.
	 */
	private boolean abstractClass = false;
	
	/**
	 * The generator which created this artefact.
	 */
	private IGenerator generator;
	
	/**
	 * <p>isAbstractClass.</p>
	 *
	 * @return a boolean.
	 */
	public boolean isAbstractClass() {
		return abstractClass;
	}

	/**
	 * <p>Setter for the field <code>abstractClass</code>.</p>
	 *
	 * @param anAbstractClass a boolean.
	 */
	public void setAbstractClass(boolean anAbstractClass) {
		abstractClass = anAbstractClass;
	}

	/**
	 * Default constructor.
	 */
	public GeneratedClass(){
		body = new StringBuilder();
		
		imports = new ArrayList<String>();
		interfaces = new ArrayList<String>();
		annotations = new ArrayList<String>();
	}
	
	/**
	 * <p>createClassFileContent.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String createClassFileContent(){
		StringBuilder ret = new StringBuilder(body.length()+200);
		
		if (typeComment==null || typeComment.length()==0){
			if (generator==null)
				typeComment = CommentGenerator.generateJavaTypeComment(getName());
			else
				typeComment = CommentGenerator.generateJavaTypeComment(getName(), generator);
		}
		
		ret.append(getTypeComment());
		ret.append("package "+getPackageName()+";");
		ret.append(CRLF).append(CRLF);
		
		for (String imp : imports){
			ret.append("import ").append(imp).append(";").append(CRLF);
		}
		
		ret.append(CRLF);

		if (clazzComment!=null && clazzComment.length()>0){
			ret.append("/**").append(CRLF);
			ret.append(" * ").append(clazzComment).append(CRLF);
//			ret.append(" * ").append("Generator: ").append(generator.getClass()).append(CRLF);
			ret.append(" */").append(CRLF);
		}

		for (String annotation : annotations) {
			ret.append(annotation).append(CRLF);
		}
		String nameDeclaration = "public "+(isAbstractClass()?"abstract ":"")+type.toJava()+" "+getName();
		
		if(!StringUtils.isEmpty(getGeneric()))
			nameDeclaration += " <" + getGeneric() + ">";
		
		if (getParent()!=null)
			nameDeclaration += " extends "+getParent().getNameWithGeneric();
		if (interfaces!=null && interfaces.size()>0){
			nameDeclaration += " implements ";
			for (int i=0; i<interfaces.size(); i++){
				if (i>0)
					nameDeclaration += ", ";
				nameDeclaration += interfaces.get(i);
			}
		}
			
		
		ret.append(nameDeclaration).append("{");
		ret.append(CRLF).append(CRLF);
		
		if (generateLogger){
			ret.append("\tprivate static Logger log = LoggerFactory.getLogger("+getName()+".class);").append(CRLF).append(CRLF);
		}
		
		
		ret.append(getBody());
		ret.append("}").append(CRLF);
		
		return ret.toString();
	}

	/**
	 * <p>addInterface.</p>
	 *
	 * @param anInterface a {@link java.lang.String} object.
	 */
	public void addInterface(String anInterface){
		if (!interfaces.contains(anInterface))
			interfaces.add(anInterface);
	}
	
	/**
	 * <p>addInterface.</p>
	 *
	 * @param anInterfaceClazz a {@link java.lang.Class} object.
	 */
	public void addInterface(Class<?> anInterfaceClazz){
		if (!anInterfaceClazz.getPackage().getName().equals(getPackageName()))
			addImport(anInterfaceClazz);
		interfaces.add(extractClassName(anInterfaceClazz));
	}

	/**
	 * <p>addImport.</p>
	 *
	 * @param clazz a {@link java.lang.Class} object.
	 */
	public void addImport(Class<?> clazz){
		addImport(clazz.getName());
	}
	
	/**
	 * <p>addImport.</p>
	 *
	 * @param anImport a {@link java.lang.String} object.
	 */
	public void addImport(String anImport){
		if (!imports.contains(anImport))
			imports.add(anImport);
	}

	/**
	 * <p>addAnnotation.</p>
	 *
	 * @param annotation a {@link java.lang.String} object.
	 * @since 2.6.3
	 */
	public void addAnnotation(String annotation){
		if (!annotations.contains(annotation))
			annotations.add(annotation);
	}

	/**
	 * <p>Getter for the field <code>imports</code>.</p>
	 *
	 * @return list of imports
	 */
	public List<String> getImports() {
		return imports;
	}

	/**
	 * <p>Setter for the field <code>imports</code>.</p>
	 *
	 * @param imports a {@link java.util.List} object.
	 */
	public void setImports(List<String> imports) {
		this.imports = imports;
	}

	/**
	 * <p>Getter for the field <code>interfaces</code>.</p>
	 *
	 * @return list of interfaces
	 */
	public List<String> getInterfaces() {
		return interfaces;
	}

	/**
	 * <p>Setter for the field <code>interfaces</code>.</p>
	 *
	 * @param interfaces a {@link java.util.List} object.
	 */
	public void setInterfaces(List<String> interfaces) {
		this.interfaces = interfaces;
	}

	/**
	 * <p>Getter for the field <code>body</code>.</p>
	 *
	 * @return the body of the class
	 */
	public StringBuilder getBody() {
		return body;
	}

	/**
	 * Sets the body of the class.
	 *
	 * @param aBody the body to set.
	 */
	public void setBody(StringBuilder aBody) {
		body = aBody;
	}

	/**
	 * <p>Getter for the field <code>annotations</code>.</p>
	 *
	 * @return a {@link java.util.List} object.
	 * @since 2.6.3
	 */
	public List<String> getAnnotations() {
		return annotations;
	}

	/**
	 * <p>Setter for the field <code>annotations</code>.</p>
	 *
	 * @param annotations a {@link java.util.List} object.
	 * @since 2.6.3
	 */
	public void setAnnotations(List<String> annotations) {
		this.annotations = annotations;
	}

	/** {@inheritDoc} */
	@Override
	public String createFileContent() {
		return createClassFileContent();
	}

	/** {@inheritDoc} */
	@Override
	public String getFileType() {
		return ".java";
	}

	/** {@inheritDoc} */
	@Override
	public String getPath() {
		return FileEntry.package2fullPath(getPackageName());
	}

	/**
	 * <p>Getter for the field <code>parent</code>.</p>
	 *
	 * @return the parent of the class
	 */
	public ClassDef getParent() {
		return parent;
	}
	
	/**
	 * <p>Setter for the field <code>parent</code>.</p>
	 *
	 * @param parentClazz a {@link java.lang.Class} object.
	 */
	public void setParent(Class<?> parentClazz){
		if (!parentClazz.getPackage().getName().equals(getPackageName()))
			addImport(parentClazz);
		setParent(extractClassName(parentClazz));
	}
	
	private String extractClassName(Class<?> aClazz){
		return aClazz.getName().substring(aClazz.getName().lastIndexOf('.')+1);
	}

	/**
	 * <p>Setter for the field <code>parent</code>.</p>
	 *
	 * @param aParent a {@link java.lang.String} object.
	 */
	public void setParent(String aParent) {
		parent = new ClassDef(aParent);
	}
	
	/**
	 * <p>Setter for the field <code>parent</code>.</p>
	 *
	 * @param aParent a {@link java.lang.String} object.
	 * @param aGeneric a {@link java.lang.String} object.
	 */
	public void setParent(String aParent, String aGeneric) {
		parent = new ClassDef(aParent, aGeneric);
	}
	
	/**
	 * <p>Getter for the field <code>packageName</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getPackageName() {
		return packageName;
	}

	/**
	 * <p>Setter for the field <code>packageName</code>.</p>
	 *
	 * @param aPackageName a {@link java.lang.String} object.
	 */
	public void setPackageName(String aPackageName) {
		packageName = aPackageName;
	}

	/**
	 * <p>Getter for the field <code>typeComment</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getTypeComment() {
		return typeComment;
	}

	/**
	 * <p>Setter for the field <code>typeComment</code>.</p>
	 *
	 * @param aTypeComment a {@link java.lang.String} object.
	 */
	public void setTypeComment(String aTypeComment) {
		typeComment = aTypeComment;
	}

	/**
	 * <p>Getter for the field <code>type</code>.</p>
	 *
	 * @return a {@link net.anotheria.asg.generator.TypeOfClass} object.
	 */
	public TypeOfClass getType() {
		return type;
	}

	/**
	 * <p>Setter for the field <code>type</code>.</p>
	 *
	 * @param aType a {@link net.anotheria.asg.generator.TypeOfClass} object.
	 */
	public void setType(TypeOfClass aType) {
		type = aType;
	}

	/**
	 * <p>isGenerateLogger.</p>
	 *
	 * @return a boolean.
	 */
	public boolean isGenerateLogger() {
		return generateLogger;
	}

	/**
	 * <p>Setter for the field <code>generateLogger</code>.</p>
	 *
	 * @param aGenerateLogger a boolean.
	 */
	public void setGenerateLogger(boolean aGenerateLogger) {
		if (aGenerateLogger) {
			addImport("org.slf4j.Logger");
			addImport("org.slf4j.LoggerFactory");
		}

		generateLogger = aGenerateLogger;
	}

	/**
	 * <p>Getter for the field <code>clazzComment</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getClazzComment() {
		return clazzComment;
	}

	/**
	 * <p>Setter for the field <code>clazzComment</code>.</p>
	 *
	 * @param aClazzComment a {@link java.lang.String} object.
	 */
	public void setClazzComment(String aClazzComment) {
		clazzComment = aClazzComment;
	}

	/**
	 * <p>Getter for the field <code>generator</code>.</p>
	 *
	 * @return a {@link net.anotheria.asg.generator.IGenerator} object.
	 */
	public IGenerator getGenerator() {
		return generator;
	}

	/**
	 * <p>Setter for the field <code>generator</code>.</p>
	 *
	 * @param aGenerator a {@link net.anotheria.asg.generator.IGenerator} object.
	 */
	public void setGenerator(IGenerator aGenerator) {
		generator = aGenerator;
	}

	/**
	 * <p>Getter for the field <code>generic</code>.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getGeneric() {
		return generic;
	}

	/**
	 * <p>Setter for the field <code>generic</code>.</p>
	 *
	 * @param generic a {@link java.lang.String} object.
	 */
	public void setGeneric(String generic) {
		this.generic = generic;
	}
	
	public static class ClassDef{
		private String name;
		private String generic;
		
		public ClassDef(String aName){
			name = aName;
		}
		
		public ClassDef(String aName, String aGeneric){
			name = aName;
			generic = aGeneric;
		}
				
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getGeneric() {
			return generic;
		}
		public void setGeneric(String generic) {
			this.generic = generic;
		}
		
		public String getNameWithGeneric(){
			return name + (StringUtils.isEmpty(generic)? "": "<" + generic + ">"); 
		}
		
		@Override
		public String toString(){
			return getName();
		}
		
		
	}

}
