package net.anotheria.asg.generator.model;


import net.anotheria.anoprise.metafactory.ServiceFactory;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;

/**
 * Base class for service generators.
 *
 * @author another
 * @version $Id: $Id
 */
public class AbstractServiceGenerator extends AbstractGenerator{
	/**
	 * Returns the interface name for the CRUD service for this module.
	 *
	 * @param m a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getInterfaceName(MetaModule m){
	    return "I"+getServiceName(m);
	}
	/**
	 * Returns the service name for a module.
	 *
	 * @param m a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static final String getServiceName(MetaModule m){
	    return m.getName()+"Service";
	}

	/**
	 * Returns the name of the factory class.
	 *
	 * @param m a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	public String getFactoryName(MetaModule m){
	    return getServiceName(m)+"Factory";
	}
	/**
	 * Returns the implementation name for the service for this MetaModule.
	 *
	 * @param m a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	public String getImplementationName(MetaModule m){
	    return getServiceName(m)+"Impl";
	}

	/**
	 * <p>getPackageName.</p>
	 *
	 * @param module a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getPackageName(MetaModule module){
		return GeneratorDataRegistry.getInstance().getContext().getServicePackageName(module);
	}

	/**
	 * <p>addAdditionalFactoryImports.</p>
	 *
	 * @param clazz a {@link net.anotheria.asg.generator.GeneratedClass} object.
	 * @param module a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 */
	protected void addAdditionalFactoryImports(GeneratedClass clazz, MetaModule module){
	}

	/**
	 * Generates a factory class.
	 *
	 * @param module a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link net.anotheria.asg.generator.GeneratedClass} object.
	 */
	protected GeneratedClass generateFactory(MetaModule module){

		GeneratedClass clazz = new GeneratedClass();
		startNewJob(clazz);
		
		clazz.setTypeComment(CommentGenerator.generateJavaTypeComment(getFactoryName(module),"The factory for the "+getInterfaceName(module)+" implementation."));
		clazz.setPackageName(getPackageName(module));

		clazz.addImport("java.util.concurrent.atomic.AtomicInteger");
		clazz.addImport(MoskitoInvokationProxy.class);
		clazz.addImport(ServiceStatsCallHandler.class);
		clazz.addImport(ServiceStatsFactory.class);
		clazz.addImport("net.anotheria.asg.service.ASGService");
	    addAdditionalFactoryImports(clazz, module);
	    
	    clazz.setName(getFactoryName(module));
	    clazz.addImport(ServiceFactory.class);
	    clazz.addInterface("ServiceFactory<"+ServiceGenerator.getInterfaceName(module)+">");
	    startClassBody();
	    
	    appendStatement("private static AtomicInteger instanceCounter = new AtomicInteger(0)");
	    appendStatement("private static "+getInterfaceName(module)+" defaultInstance = create"+getServiceName(module)+"()");
	    emptyline();
	    
	    appendString("public "+getInterfaceName(module)+" create(){");
	    increaseIdent();
	    appendStatement("return create"+getServiceName(module)+"()");
		closeBlockNEW();
	    emptyline();
	    
	    appendString("public static "+getInterfaceName(module)+" create"+getServiceName(module)+"(){");
	    increaseIdent();
	    appendString("MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(");
	    increaseIdent();
	    appendString("createInstance(),");
	    appendString("new ServiceStatsCallHandler(),");
	    appendString("new ServiceStatsFactory(),");
	    appendString("\""+getInterfaceName(module)+"-\"+instanceCounter.incrementAndGet(),");
	    appendString(quote("service"),",");
	    appendString(quote(getMoskitoSubsystem()),",");
	    appendString(getSupportedInterfacesList(module));
	    decreaseIdent();
	    appendString(");");
	    appendStatement("return ("+getInterfaceName(module)+") proxy.createProxy()");
	    
	    closeBlockNEW();
	    emptyline();
	    
	    appendString("private static "+getInterfaceName(module)+" createInstance(){");
	    increaseIdent();
	    appendString("return "+getImplementationName(module)+".getInstance();");
	    append(closeBlock());
	    emptyline();
	    
	    appendString("static "+getInterfaceName(module)+" getDefaultInstance(){");
	    increaseIdent();
	    appendString("return defaultInstance;");
		closeBlockNEW();
	    return clazz;
	} 
	
	//returns a comma-separated list of all interfaces supported by this impl, which the proxy must map.
	/**
	 * <p>getSupportedInterfacesList.</p>
	 *
	 * @param module a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getSupportedInterfacesList(MetaModule module){
		return getInterfaceName(module)+".class"+", ASGService.class";
	}
	
	/**
	 * Returns the base exception name.
	 *
	 * @param module a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getExceptionName(MetaModule module){
		return ServiceGenerator.getExceptionName(module);
	}
	
	/**
	 * <p>getMoskitoSubsystem.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getMoskitoSubsystem(){
		return "asg";
	}
	
}
