package net.anotheria.asg.generator.view.jsp;

import net.anotheria.asg.generator.*;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.meta.MetaDialog;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.ArrayUtils;
import net.anotheria.util.StringUtils;

import java.util.List;

/**
 * Generator for the JSP files used for generations of the view jsps.
 *
 * @author lrosenberg
 * @version $Id: $Id
 */
public abstract class AbstractJSPGenerator extends AbstractGenerator{
	/**
	 * Captions for the Queries link in the footer.
	 */
	public static final String FOOTER_SELECTION_QUERIES = "Queries";
	/**
	 * Caption for the CMS link in the footer.
	 */
	public static final String FOOTER_SELECTION_CMS     = "CMS";

	/*
	 * The context for the generation.
	 */
//	private Context context;
	
	
	/** {@inheritDoc} */
	@Override
	protected void appendCommentLine(String commentLine){
		appendString("<%-- " + commentLine + " --%>");
	}
	
	
	/**
	 * Generates the header for all jsp files.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getBaseJSPHeader(){
		String ret = "";
		ret += "<%-- generated by AbstractJSPGenerator.getBaseJSPHeader --%>"+CRLF;
		ret += "<%@ page"+CRLF;
		ret += "\tcontentType=\"text/html;charset="+GeneratorDataRegistry.getInstance().getContext().getEncoding()+"\" session=\"true\""+CRLF;
		
		ret += "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\""+CRLF;
		ret += "%><%@ taglib uri=\"/WEB-INF/tlds/anosite.tld\" prefix=\"as\""+CRLF;
		ret += "%><%@ page isELIgnored =\"false\" %>"+CRLF;
		ret += "<%-- / generated by AbstractJSPGenerator.getBaseJSPHeader --%>"+CRLF;
		return ret;
	}
	
	/**
	 * Generates the header for jsp files that generate xml exports.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getBaseXMLHeader(){
		String ret = "";
		ret += "<%@ page"+CRLF;
		ret += "\tcontentType=\"text/xml;charset="+GeneratorDataRegistry.getInstance().getContext().getEncoding()+"\" session=\"true\""+CRLF;
		
		ret += "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\""+CRLF;
		ret += "%><%@ taglib uri=\"/WEB-INF/tld/ano-tags-xml.tld\" prefix=\"ano-xml\""+CRLF;
		ret += "%>";
		return ret;
	}

	/**
	 * Generates the header for jsp files that generate csv exports.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getBaseCSVHeader(){
		String ret = "";
		ret += "<%@ page"+CRLF;
		ret += "\tcontentType=\"application/msexcel;charset="+GeneratorDataRegistry.getInstance().getContext().getEncoding()+"\" session=\"true\""+CRLF;
		
		ret += "%><%@ taglib uri=\"http://www.anotheria.net/ano-tags\" prefix=\"ano\""+CRLF;
		ret += "%>";
		return ret;
	}
	
	private String getFooterLink(String selection, String link, String linkCaption){
		if (selection!=null && selection.equals(linkCaption)){
			return "<strong>"+linkCaption+"</strong>"; 
		}
		return "&nbsp;<a href=\"<ano:tslink>"+link+"</ano:tslink>\">"+linkCaption+"</a>";

	}

	/**
	 * Generates a footer file which is included by other jsps.
	 *
	 * @param view the vie to generate the footer for.
	 * @param selection ?
	 * @param name the name of the file.
	 * @return a {@link net.anotheria.asg.generator.GeneratedJSPFile} object.
	 */
	protected GeneratedJSPFile generateFooter(MetaView view, String selection, String name){
		
		GeneratedJSPFile jsp = new GeneratedJSPFile();
		startNewJob(jsp);
		
		jsp.setPackage(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED)+".jsp");
		jsp.setName(name);
		
		append(getBaseJSPHeader());
		
		appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		increaseIdent();
		appendString("<tr>");
		increaseIdent();

		appendString("<td>");
		increaseIdent();
		
		appendString(getFooterLink(selection, defineLinkToViewCms(view), FOOTER_SELECTION_CMS));
		appendString("&nbsp;|&nbsp;");
		//appendString("<a href=\""+defineLinkToViewQueries(view)+"\">Queries</a>");
		appendString(getFooterLink(selection, defineLinkToViewQueries(view), FOOTER_SELECTION_QUERIES));
		
		decreaseIdent();
		appendString("</td>");
		appendString("<td>");
		appendIncreasedString("<jsp:include page="+quote(SharedFooterJspGenerator.getSharedJspFooterPageName())+" flush="+quote("false")+"/>");
		appendString("</td>");
		appendString("<td align="+quote("right")+">");
		increaseIdent();
		
		appendString("Generated by "+Generator.getProductString()+" V "+Generator.getVersionString());
		//String timestamp = NumberUtils.makeISO8601TimestampString(System.currentTimeMillis());
		String timestamp = "Timestamp unset";
		appendString(" on "+timestamp+"&nbsp;|&nbsp;");
		appendString("<a href=\"<ano:tslink>logout</ano:tslink>\">Logout</a>&nbsp;");
		
		decreaseIdent();
		appendString("</td>");
		decreaseIdent();
		appendString("</tr>");
		decreaseIdent();
		appendString("</table>");
		
		append(getBaseJSPFooter());
			
		return jsp;
	}
	
	private String defineLinkToViewQueries(MetaView view){
		String ret = "#";
		List<MetaSection> sections = view.getSections();
		for (int i=0; i<sections.size(); i++){
			MetaSection s = sections.get(i);
			if (s instanceof MetaModuleSection){
				MetaModuleSection ms = (MetaModuleSection)s;
				MetaDocument targetDoc = ms.getDocument();
				if (targetDoc.getLinks().size()>0){
					return CMSMappingsConfiguratorGenerator.getShowQueriesPath(targetDoc);
				}
			}
		}
		return ret;
	}
	
	/**
	 * Returns image tag for the duplicate entry image.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getDuplicateImage(){
		return getDuplicateImage("duplicate");
	}

	private String defineLinkToViewCms(MetaView view){
		String ret = "#";
		List<MetaSection> sections = view.getSections();
		for (int i=0; i<sections.size(); i++){
			MetaSection s = sections.get(i);
			if (s instanceof MetaModuleSection){
				MetaDocument targetDoc = ((MetaModuleSection)s).getDocument();
				return CMSMappingsConfiguratorGenerator.getShowCMSPath(targetDoc);
			}
		}
		return ret;
	}

	/**
	 * Returns the basic footer used in all jsps.
	 *
	 * @return content of the base jsp footer.
	 */
	protected String getBaseJSPFooter(){
		String ret = "<!-- generated by "+Generator.getProductString()+" V "+Generator.getVersionString()+", visit www.anotheria.net for details -->";
		return ret;
	}
	
	/**
	 * Returns the name of the jsp file for the show page for the document.
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getShowPageName(MetaDocument doc){
		return "Show"+doc.getMultiple();
	}
	
	/**
	 * <p>getSearchResultPageName.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public static String getSearchResultPageName(){
		return "SearchResult";
	}

	/**
	 * Returns the page name for the version info page.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public static String getVersionInfoPageName(){
		return "VersionInfo";
	}

	/**
	 * Returns the page name for the version info page for the given document.
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getVersionInfoPageName(MetaDocument doc){
		return getVersionInfoPageName();
	}

	
	/**
	 * <p>getShowQueriesPageName.</p>
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getShowQueriesPageName(MetaDocument doc){
		return "Show"+doc.getMultiple()+"Queries";
	}
	
	/**
	 * Returns the name of the jsp file for the csv page export for the document.
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getExportAsCSVPageName(MetaDocument doc){
		return "Show"+doc.getMultiple()+"AsCSV";
	}

	/**
	 * Returns the name of the jsp file for the xml page export for the document.
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getExportAsXMLPageName(MetaDocument doc){
		return "Show"+doc.getMultiple()+"AsXML";
	}

	/**
	 * Returns the name of the edit page for this document.
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getEditPageName(MetaDocument doc){
		return "Edit"+doc.getName();
	}
	
	/**
	 * <p>getDialogName.</p>
	 *
	 * @param dialog a {@link net.anotheria.asg.generator.view.meta.MetaDialog} object.
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getDialogName(MetaDialog dialog, MetaDocument doc){
		return dialog.getName()+doc.getName();
	}
	
	/**
	 * <p>getLinksToMePageName.</p>
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getLinksToMePageName(MetaDocument doc){
		return "LinksTo"+doc.getName();
	}

	/**
	 * <p>getContainerPageName.</p>
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @param table a {@link net.anotheria.asg.generator.meta.MetaContainerProperty} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getContainerPageName(MetaDocument doc, MetaContainerProperty table){
		return "Show"+doc.getName()+StringUtils.capitalize(table.getName());
	}
	
	/**
	 * <p>generateTimestampedLinkPath.</p>
	 *
	 * @param path a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected static String generateTimestampedLinkPath(String path){
		return "<ano:tslink>"+path+"</ano:tslink>";
	}

	

	/**
	 * <p>getCurrentImagePath.</p>
	 *
	 * @param imageName a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getCurrentImagePath(String imageName){
		return getImagePath(imageName, GeneratorDataRegistry.getInstance().getContext());
	}
	
	/**
	 * <p>getImagePath.</p>
	 *
	 * @param imageName a {@link java.lang.String} object.
	 * @param context a {@link net.anotheria.asg.generator.Context} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getImagePath(String imageName, Context context){
		return context.getApplicationURLPath()+"/img/"+imageName;
	}

	/**
	 * <p>getCurrentCSSPath.</p>
	 *
	 * @param stylesheetName a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getCurrentCSSPath(String stylesheetName){
		return getCSSPath(stylesheetName, GeneratorDataRegistry.getInstance().getContext());
	}
	
	/**
	 * <p>getCurrentJSPath.</p>
	 *
	 * @param jsName a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getCurrentJSPath(String jsName){
		return getJSPath(jsName, GeneratorDataRegistry.getInstance().getContext());
	}
	
	/**
	 * <p>getCurrentYUIPath.</p>
	 *
	 * @param yuiName a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getCurrentYUIPath(String yuiName){
		return getYUIPath(yuiName, GeneratorDataRegistry.getInstance().getContext());
	}
	
	/**
	 * <p>getCurrentJavaScriptPath.</p>
	 *
	 * @param javaScript a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getCurrentJavaScriptPath(String javaScript){
		return getJavaScriptPath(javaScript, GeneratorDataRegistry.getInstance().getContext());
	}

	/**
	 * <p>getCSSPath.</p>
	 *
	 * @param stylesheetName a {@link java.lang.String} object.
	 * @param context a {@link net.anotheria.asg.generator.Context} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getCSSPath(String stylesheetName, Context context){
		return context.getApplicationURLPath()+"/cms_static/css/"+stylesheetName;
	}

	/**
	 * <p>getJSPath.</p>
	 *
	 * @param jsName a {@link java.lang.String} object.
	 * @param context a {@link net.anotheria.asg.generator.Context} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getJSPath(String jsName, Context context){
		return context.getApplicationURLPath()+"/cms_static/js/"+jsName;
	}

	/**
	 * <p>getJavaScriptPath.</p>
	 *
	 * @param javaScript a {@link java.lang.String} object.
	 * @param context a {@link net.anotheria.asg.generator.Context} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getJavaScriptPath(String javaScript, Context context){
		return context.getApplicationURLPath()+"/cms_static/js/"+javaScript;
	}
	
	/**
	 * <p>getYUIPath.</p>
	 *
	 * @param yuiName a {@link java.lang.String} object.
	 * @param context a {@link net.anotheria.asg.generator.Context} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getYUIPath(String yuiName, Context context){
		return context.getApplicationURLPath()+"/cms_static/yui/"+yuiName;
	}

	/**
	 * <p>getPackage.</p>
	 *
	 * @param mod a {@link net.anotheria.asg.generator.meta.MetaModule} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getPackage(MetaModule mod){
		return GeneratorDataRegistry.getInstance().getContext().getJspPackageName(mod);
	}

	/**
	 * <p>getPackage.</p>
	 *
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @return a {@link java.lang.String} object.
	 */
	public static String getPackage(MetaDocument doc){
		return GeneratorDataRegistry.getInstance().getContext().getJspPackageName(doc);
	}

	/**
	 * Returns the tag for the delete image in the overview.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getDeleteImage(){
		return getDeleteImage("delete");
	}
	
	/**
	 * Returns the tag for the preview image in the overview.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getPreviewImage(){
		return getPreviewImage("preview");
	}

	/**
	 * Returns the tag for the version info image in the overview. Note: for now it returns a 'V' text.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getVersionImage(){
		return getVersionImage("version");//getDeleteImage("delete");
	}

	/**
	 * Returns the tag for the edit image in the overview.
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getEditImage(){
		return getEditImage("edit");
	}
	
	/**
	 * Returns the tag for the Version in the overview with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getVersionImage(String alt){
		return getImage("version",alt);
	}

	/**
	 * Returns the tag for the delete image in the overview with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getDeleteImage(String alt){
		return getImage("delete",alt);
	}
	
	/**
	 * Returns the tag for the preview image in the overview with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getPreviewImage(String alt){
		return getImage("preview",alt);
	}

    /**
     * Returns the tag for the lock image in the overview.
     *
     * @return created image tag
     */
    protected String getLockImage(){
        return getLockImage("lock");
    }
    /**
     * Returns the tag for the lock image in the overview.
     *
     * @return created image tag
     */
    protected String getUnLockImage(){
        return getUnLockImage("unlock");
    }
    /**
     * Returns the tag for the lock image in the overview with the given alt tag.
     *
     * @param alt actually alt - for the image tag
     * @return created image tag
     */
    protected String getLockImage(String alt){
        return getImage("lock",alt);
    }

    /**
     * Returns the tag for the unLock image in the overview with the given alt tag.
     *
     * @param alt actually alt for image tag
     * @return created image tag
     */
    protected String getUnLockImage(String alt){
       return getImage("unlock",alt);
    }

	/**
	 * Returns the tag for the move to the top image in the list view with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getTopImage(String alt){
		return getImage("top",alt);
	}

	/**
	 * Returns the tag for the move to the bottom image in the list view with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getBottomImage(String alt){
		return getImage("bottom",alt);
	}

	/**
	 * Returns the tag for the move up image in the list view with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getUpImage(String alt){
		return getImage("up",alt);
	}

	/**
	 * Returns the tag for the move down image in the list view with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getDownImage(String alt){
		return getImage("down",alt);
	}

	/**
	 * Returns the tag for the duplicate image in the overview with the given alt tag.
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getDuplicateImage(String alt){
		return getImage("clone",alt);
	}

	/**
	 * <p>getEditImage.</p>
	 *
	 * @param alt a {@link java.lang.String} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getEditImage(String alt){
		return getImage("edit_icon",alt);
	}
	
	/**
	 * Returns the img tag to embed an image into the jsp.
	 *
	 * @param name name of the gif file containing the image.
	 * @param alt alternative description (alt tag).
	 * @return a {@link java.lang.String} object.
	 */
	protected String getImage(String name, String alt){
		return "<img src=\""+GeneratorDataRegistry.getInstance().getContext().getApplicationURLPath()+"/cms_static/img/"+name+".gif"+"\" alt="+quote(alt)+" title="+quote(alt)+">";
	}

	/**
	 * <p>getContext.</p>
	 *
	 * @return a {@link net.anotheria.asg.generator.Context} object.
	 */
	public Context getContext() {
		return GeneratorDataRegistry.getInstance().getContext();
	}

	/**
	 * Generates pragmas for a given view.
	 *
	 * @param view the view to generate pragmas for.
	 */
	protected void generatePragmas(MetaView view){
	    generatePragmas();
	}
	
	/**
	 * Generates generic pragmas.
	 * Adds the generated content to the current job.
	 */
	protected void generatePragmas(){
		appendString("<meta http-equiv=\"pragma\" content=\"no-cache\"/>");
		appendString("<meta http-equiv=\"Cache-Control\" content=\"no-cache, must-revalidate\"/>");
		appendString("<meta name=\"Expires\" content=\"0\"/>");
		appendString("<meta http-equiv=\"Content-Type\" content=\"text/html; charset="+GeneratorDataRegistry.getInstance().getContext().getEncoding()+"\"/>");
	}
	
	/**
	 * <p>openTag.</p>
	 *
	 * @param tag a {@link java.lang.String} object.
	 * @param params a {@link java.lang.String} object.
	 */
	protected void openTag(String tag, String params){
		appendString("<"+tag+(params.length()>0 ? " ":"")+params+">");
	}

	/**
	 * <p>closeTag.</p>
	 *
	 * @param tag a {@link java.lang.String} object.
	 * @param params a {@link java.lang.String} object.
	 */
	protected void closeTag(String tag, String params){
		appendString("</"+tag+(params.length()>0 ? " ":"")+params+">");
	}

	/**
	 * <p>openTR.</p>
	 *
	 * @param additionalParams a {@link java.lang.String} object.
	 */
	protected void openTR(String additionalParams){
		openTag("tr", additionalParams);
		increaseIdent();
	}
	
	/**
	 * <p>closeTR.</p>
	 *
	 * @param additionalParams a {@link java.lang.String} object.
	 */
	protected void closeTR(String additionalParams){
		decreaseIdent();
		closeTag("tr", additionalParams);
	}

	/**
	 * <p>openTR.</p>
	 */
	protected void openTR(){
		openTR("");
	}
	
	/**
	 * <p>closeTR.</p>
	 */
	protected void closeTR(){
		closeTR("");
	}
	
	/**
	 * Opens a table cell.
	 */
	protected void openTD(){
		openTD("");
	}
	
	/**
	 * <p>closeTD.</p>
	 */
	protected void closeTD(){
		closeTD("");
	}
	
	/**
	 * Opens a table cell.
	 *
	 * @param additionalParams additional parameters.
	 */
	protected void openTD(String additionalParams){
		openTag("td", additionalParams);
	}
	
	/**
	 * <p>closeTD.</p>
	 *
	 * @param additionalParams a {@link java.lang.String} object.
	 */
	protected void closeTD(String additionalParams){
		closeTag("td", additionalParams);
	}
	
	
	/**
	 * Appends to generation output tag without body.
	 *
	 * @param tag tag name
	 * @param id html id attribute
	 * @param clazz html class attribute
	 * @param attrs array of tag attributes
	 */
	protected void tag(String tag, String id, String clazz, TagAttribute... attrs){
		attrs = ArrayUtils.mergeArrays(new TagAttribute[]{new TagAttribute("id", id), new TagAttribute("class", clazz)}, attrs);
		tag(tag, attrs);
	}

	/**
	 * Appends to generation output tag without body.
	 *
	 * @param tag tag name
	 * @param clazz html class attribute
	 * @param attrs array of tag attributes
	 */
	protected void tag(String tag, String clazz, TagAttribute... attrs){
		attrs = ArrayUtils.mergeArrays(new TagAttribute[]{new TagAttribute("class", clazz)}, attrs);
		tag(tag, attrs);
	}
	
	/**
	 * Appends to generation output tag without body.
	 *
	 * @param tag tag name
	 * @param attrs array of tag attributes
	 */
	protected void tag(String tag, TagAttribute... attrs){
		StringBuilder attrsStr = new StringBuilder();
		for(TagAttribute attr:attrs)
			attrsStr.append(' ' + attr.toString());
		appendString("<"+tag, attrsStr.toString(), "/>");
	}
	
	/**
	 * Appends to generation output opening for tag.
	 *
	 * @param tag tag name
	 * @param id html id attribute
	 * @param clazz html class attribute
	 * @param attrs array of tag attributes
	 */
	protected void tagOpen(String tag, String id, String clazz, TagAttribute... attrs){
		attrs = ArrayUtils.mergeArrays(new TagAttribute[]{new TagAttribute("id", id), new TagAttribute("class", clazz)}, attrs);
		tagOpen(tag, attrs);
	}

	/**
	 * Appends to generation output opening for tag.
	 *
	 * @param tag tag name
	 * @param clazz html class attribute
	 * @param attrs array of tag attributes
	 */
	protected void tagOpen(String tag, String clazz, TagAttribute... attrs){
		attrs = ArrayUtils.mergeArrays(new TagAttribute[]{new TagAttribute("class", clazz)}, attrs);
		tagOpen(tag, attrs);
	}
	
	/**
	 * Appends to generation output opening for tag.
	 *
	 * @param tag tag name
	 * @param attrs array of tag attributes
	 */
	protected void tagOpen(String tag, TagAttribute... attrs){
		StringBuilder attrsStr = new StringBuilder();
		for(TagAttribute attr:attrs)
			attrsStr.append(' ' + attr.toString());
		appendString("<"+tag, attrsStr.toString(), ">");
		increaseIdent();
	}
	
	
	/**
	 * Appends to generation output closing for tag.
	 *
	 * @param tag tag name
	 */
	protected void tagClose(String tag){
		decreaseIdent();
		appendString("</"+tag+">");
	}
	
	/**
	 * Appends to generation output script tag with type javascript.
	 */
	protected void openJavaScript(){
		tagOpen("script", new TagAttribute("type", "text/javascript"));
	}
	
	/**
	 * Appends to generation output script tag closing.
	 */
	protected void closeJavaScript(){
		tagClose("script");
	}
	
	/**
	 * HTML/JSP tag attribute object representation.
	 * @author denis
	 *
	 */
	protected static class TagAttribute{
		/**
		 * attr name.
		 */
		private String name;
		/**
		 * attr value.
		 */
		private String value;
		
		public TagAttribute(String aName, String aValue) {
			name = aName;
			value = aValue;
		}
		
		@Override public String toString(){
			return StringUtils.isEmpty(value)? name: name + "=" + '"' + value + '"'; 
		}
	}
	
	/**
	 * <p>getTopMenuPage.</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	protected String getTopMenuPage(){
		return "../../shared/jsp/"+MenuJspGenerator.getMenuPageName();		
	}

	/**
	 * <p>getMenuName.</p>
	 *
	 * @param view a {@link net.anotheria.asg.generator.view.meta.MetaView} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getMenuName(MetaView view){
		return "../../shared/jsp/"+StringUtils.capitalize(view.getName())+"Menu";		
	}
	
	/**
	 * <p>getFooterName.</p>
	 *
	 * @param view a {@link net.anotheria.asg.generator.view.meta.MetaView} object.
	 * @return a {@link java.lang.String} object.
	 */
	protected String getFooterName(MetaView view){
		return "../../shared/jsp/"+StringUtils.capitalize(view.getName())+"Footer";		
	}
}
