package net.anotheria.asg.generator.view.jsp;

import java.util.List;

import net.anotheria.asg.generator.GeneratedJSPFile;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.util.DirectLink;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaView;

/**
 * <p>LinksToMePageJspGenerator class.</p>
 *
 * @author another
 * @version $Id: $Id
 */
public class LinksToMePageJspGenerator extends AbstractJSPGenerator{
	
	/**
	 * <p>generate.</p>
	 *
	 * @param section a {@link net.anotheria.asg.generator.view.meta.MetaModuleSection} object.
	 * @param view a {@link net.anotheria.asg.generator.view.meta.MetaView} object.
	 * @return a {@link net.anotheria.asg.generator.GeneratedJSPFile} object.
	 */
	public GeneratedJSPFile generate(MetaModuleSection section, MetaView view){

		GeneratedJSPFile jsp = new GeneratedJSPFile();
		startNewJob(jsp);
		jsp.setName(getLinksToMePageName(section.getDocument()));
		jsp.setPackage(getContext().getJspPackageName(section.getModule()));
		
		resetIdent();
		
		append(getBaseJSPHeader());
		
		appendString("<!--  generated by JspMafViewGenerator.generateLinksToDocument -->");
		appendString("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
		increaseIdent();
		appendString("<head>");
		increaseIdent();
		appendString("<title>Direct links to the "+section.getDocument().getName()+"[<ano:write name=\"objectId\"/>]</title>");
		generatePragmas(view);
		appendString("<link href=\""+getCurrentCSSPath("newadmin.css")+"\" rel=\"stylesheet\" type=\"text/css\">");
		decreaseIdent();
		appendString("</head>");
		appendString("<body>");
		increaseIdent();		
		
		appendString("<ano:present name="+quote("linksToMe")+" scope="+quote("request")+">");
		appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		increaseIdent();
		appendString("<tr>");
		increaseIdent();
		appendString("<td>Direct links to the "+section.getDocument().getName()+"[<ano:write name=\"objectId\"/>]</td>");
		decreaseIdent();
		appendString("</tr>");
		appendString("<ano:iterate name="+quote("linksToMe")+" id="+quote("linkToMe")+" type="+quote("net.anotheria.asg.util.bean.LinkToMeBean")+" >");
		increaseIdent();
		appendString("<tr>");
		increaseIdent();
	
		String docDescriptionStatement = "Type: <ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentType")+"/>";
		docDescriptionStatement += ", Id: <a href="+quote("<ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentLink")+"/>")+" ><ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentId")+"/></a>";
		docDescriptionStatement += "<ano:equal name="+quote("linkToMe")+" property="+quote("descriptionAvailable") +" value="+quote("true")+">, Name: <b> <a href="+quote("<ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentLink")+"/>")+" ><ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentDescription")+"/></a></b></ano:equal>";
		docDescriptionStatement += ", in <b><ano:write name="+quote("linkToMe")+" property="+quote("targetDocumentProperty")+"/></b>.";
		appendString("<td>"+docDescriptionStatement+"</td>");
		decreaseIdent();
		appendString("</tr>");
		decreaseIdent();
		appendString("</ano:iterate>");
		appendString("</table>");
		
		appendString("<br/>");
		appendString("<br/>");
		appendString("</ano:present>");
		appendString("<!-- ");
		appendString("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
		increaseIdent();
		appendString("<tr>");
		increaseIdent();
		appendString("<td>This "+section.getDocument().getName()+" can be used in following documents:</td>");
		decreaseIdent();
		appendString("</tr>");
		
		List<DirectLink> linkee = GeneratorDataRegistry.getInstance().findLinksToDocument(section.getDocument());
		for (DirectLink l : linkee){
			appendString("<tr>");
			increaseIdent();
			appendString("<td>");
			appendString(l.getModule().getName()+"."+l.getDocument().getName()+", property: "+l.getProperty().getName());
			appendString("</td>");
			decreaseIdent();
			appendString("</tr>");
		}
		
		decreaseIdent();
		appendString("</table>");
		appendString("-->");
		

		decreaseIdent();
		appendString("</body>");
		decreaseIdent();
		
		decreaseIdent();
		appendString("</html>");
		appendString("<!-- / generated by JspMafViewGenerator.generateLinksToDocument -->");
		
		append(getBaseJSPFooter());
		
		return jsp;
	}	
	
}
