package net.anotheria.asg.generator.view.jsp;

import java.util.List;

import net.anotheria.asg.generator.GeneratedJSPFile;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.meta.MetaTableProperty;
import net.anotheria.asg.generator.view.CMSMappingsConfiguratorGenerator;
import net.anotheria.asg.generator.view.action.ModuleBeanGenerator;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.util.StringUtils;

/**
 * Generates the jsps for the edit view.
 *
 * @author another
 * @version $Id: $Id
 */
public class TablePageJspGenerator extends AbstractJSPGenerator {
	
	
	
	/**
	 * <p>generate.</p>
	 *
	 * @param section a {@link net.anotheria.asg.generator.view.meta.MetaModuleSection} object.
	 * @param doc a {@link net.anotheria.asg.generator.meta.MetaDocument} object.
	 * @param table a {@link net.anotheria.asg.generator.meta.MetaTableProperty} object.
	 * @return a {@link net.anotheria.asg.generator.GeneratedJSPFile} object.
	 */
	public GeneratedJSPFile generate(MetaModuleSection section, MetaDocument doc, MetaTableProperty table){
		
		GeneratedJSPFile jsp = new GeneratedJSPFile();
		startNewJob(jsp);
		jsp.setName(getContainerPageName(doc, table));
		
	    resetIdent();
	    
	    List<MetaProperty> columns = table.getColumns();
	    String formName = CMSMappingsConfiguratorGenerator.getContainerEntryFormName(doc, table);
	    
		append(getBaseJSPHeader());
		
		appendString("<!--  generated by JspMafViewGenerator.generateTablePage -->");
		appendString("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
		increaseIdent();
		appendString("<head>");
		increaseIdent();
		appendString("<title>Edit "+doc.getName()+StringUtils.capitalize(table.getName())+"</title>");
		generatePragmas();
		appendString("<link href=\""+getCurrentCSSPath("newadmin.css")+"\" rel=\"stylesheet\" type=\"text/css\">");
		decreaseIdent();
		appendString("</head>");
		appendString("<body>");
		increaseIdent();		
		
		appendString("<table width="+quote("100%")+" cellspacing="+quote("1")+" cellpadding="+quote("1")+" border="+quote("0")+">");
		increaseIdent();
		appendString("<tr class="+quote("lineCaptions")+">");
	    appendIncreasedString("<td width=\"1%\">Pos</td>");
		for (int i=0; i<columns.size(); i++){
		    MetaProperty p = columns.get(i);
		    appendIncreasedString("<td>"+StringUtils.capitalize(table.extractSubName(p))+"</td>");
		}
	    appendIncreasedString("<td width=\"1%\">&nbsp;</td>");
		appendString("</tr>");
		appendString("<ano:iterate name="+quote("rows")+" id="+quote("row")+" type="+quote(ModuleBeanGenerator.getContainerEntryFormImport(doc, table))+" indexId="+quote("ind")+">");
		increaseIdent();
		appendString("<tr class=\"<%=ind.intValue()%2==0 ? \"lineLight\" : \"lineDark\"%>\">");
		increaseIdent();
		appendString("<td width="+quote("1%")+"><ano:write name="+quote("row")+" property="+quote("position")+"/></td>");
		for (int i=0; i<columns.size(); i++){
		    MetaProperty p = columns.get(i);
		    appendString("<td><ano:write name="+quote("row")+" property="+quote(table.extractSubName(p))+"/></td>");
		}
		String parameter = "pId=<ano:write name="+quote("row")+" property="+quote("ownerId")+"/>";
		parameter += "&pPosition=<ano:write name="+quote("row")+" property="+quote("position")+"/>";
		appendString("<td width="+quote("1%")+"><a href="+quote(CMSMappingsConfiguratorGenerator.getContainerPath(doc, table, CMSMappingsConfiguratorGenerator.ACTION_DELETE)+"?"+parameter)+">"+getDeleteImage("delete row")+"</a></td>");
		decreaseIdent();
		appendString("</tr>");
		decreaseIdent();
		appendString("</ano:iterate>");
		decreaseIdent();
		appendString("</table>");
		appendString("<br>");
		decreaseIdent();
		appendString("<table width="+quote("100%")+" cellspacing="+quote("1")+" cellpadding="+quote("1")+" border="+quote("0")+">");
		increaseIdent();
		//TODO removing of "html:" may cause some problems...
		//appendString("<html:form action="+quote(CMSMappingsConfiguratorGenerator.getContainerPath(doc, table, CMSMappingsConfiguratorGenerator.ACTION_ADD))+">");
		appendString("<form action="+quote(CMSMappingsConfiguratorGenerator.getContainerPath(doc, table, CMSMappingsConfiguratorGenerator.ACTION_ADD))+">");
		//appendString("<html:hidden property="+quote("ownerId")+"/>");
		appendString("<input type="+quote("hidden")+" name="+quote("ownerId")+"/>");
		appendString("<input type="+quote("hidden")+" name="+quote("pId")+" value=\"<bean:write name="+quote(formName)+" property="+quote("ownerId")+"/>\">");
		appendString("<tr class="+quote("lineCaptions")+">");
	    appendIncreasedString("<td colspan="+quote("2")+">Add row:</td>");
	    appendString("</tr>");
	    for (int i=0; i<columns.size()+2; i++){
	        appendString("<tr class="+quote(i%2==0 ? "lineLight" : "lineDark")+">");
			increaseIdent();
	        
	        if (i<columns.size()){
				MetaProperty p = columns.get(i);
				appendString("<td align=\"right\" width=\"35%\">");
				increaseIdent();
				String name = table.extractSubName(p);
				if (name==null || name.length()==0)
					name = "&nbsp;";
				appendString(name+":");
				decreaseIdent(); 
				appendString("</td>");
				decreaseIdent();
	
				appendString("<td align=\"left\" width=\"65%\">&nbsp;");
				String field = "";
				field += "<input type=\"text\" name="+quote(name);
				field += " value=\"<ano:write name="+quote(CMSMappingsConfiguratorGenerator.getContainerEntryFormName(doc,table ))+" property="+quote(name)+"/>";
				field += "\">";
				appendIncreasedString(field);
				appendString("</td>");
	        }else{
	            if (i==columns.size()){
					appendString("<td colspan="+quote("2")+">&nbsp;");
	            }else{
					appendString("<td align=\"right\" width=\"35%\">&nbsp;</td>");
					appendString("<td align=\"left\" width=\"65%\">");
					appendIncreasedString("<a href="+quote("#")+" onClick="+quote("document."+formName+".submit()")+">&nbsp;&raquo&nbsp;Add&nbsp;</a>");
					appendString("</td>");

	            }
	        }
	        decreaseIdent();
	        appendString("</tr>");
	    }
	    //appendString("</html:form>");
	    appendString("</form>");

	    
	    appendString("</body>");
		decreaseIdent();
		appendString("</html>");
		appendString("<!-- / generated by JspMafViewGenerator.generateTablePage -->");
		
		append(getBaseJSPFooter());
		
	    
		return jsp;
	}

	
	
	

}
