/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.PropertyType;

public class BooleanProperty
extends Property {
    private static final long serialVersionUID = -6112656517280319094L;

    public BooleanProperty(String name, boolean value) {
        this(name, (Boolean)value);
    }

    public BooleanProperty(String name, Boolean value) {
        super(name, value);
    }

    public Boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public boolean getboolean() {
        return this.getBoolean();
    }

    public void setboolean(boolean aValue) {
        this.setBoolean(aValue);
    }

    public void setBoolean(Boolean aValue) {
        super.setValue(aValue);
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Boolean) {
            super.setValue(o);
            return;
        }
        if (o instanceof String) {
            try {
                super.setValue(Boolean.valueOf((String)o));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException(o + " is not a legal value for BooleanProperty");
    }

    @Override
    public long getSizeInBytes() {
        return 1L;
    }

    @Override
    protected Object cloneValue() {
        return this.getboolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public PropertyType getPropertyType() {
        return PropertyType.BOOLEAN;
    }
}

