/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.anodoc.data.DataHolder;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.DoubleProperty;
import net.anotheria.anodoc.data.FloatProperty;
import net.anotheria.anodoc.data.ICompositeDataObject;
import net.anotheria.anodoc.data.IntProperty;
import net.anotheria.anodoc.data.ListProperty;
import net.anotheria.anodoc.data.LongProperty;
import net.anotheria.anodoc.data.NoSuchDataHolderException;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.CallContext;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;

public class Document
extends DataHolder
implements ICompositeDataObject,
Cloneable {
    private static final long serialVersionUID = -5433016437476873070L;
    private Hashtable<String, DataHolder> dataStorage = new Hashtable();
    public static final String PROP_TYPE_IDENTIFIER = "###my_type###";
    public static final String PROP_LAST_UPDATE = "###last_update###";
    public static final String PROP_AUTHOR = "###author###";

    public Document(String id) {
        super(id);
        this.putProperty(new StringProperty("__type_identifier__", "doc"));
    }

    public Document(Document anotherDocument) {
        super("");
        Hashtable<String, DataHolder> srcTable = anotherDocument.dataStorage;
        Enumeration<DataHolder> src = srcTable.elements();
        while (src.hasMoreElements()) {
            Property p = (Property)src.nextElement();
            try {
                this.putProperty((Property)p.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Clone failed: " + e.getMessage());
            }
        }
    }

    public DataHolder getDataHolder(String name) throws NoSuchDataHolderException {
        DataHolder holder = this.dataStorage.get(name);
        if (holder == null) {
            throw new NoSuchDataHolderException(name);
        }
        return holder;
    }

    public Document getDocument(String name) throws NoSuchDocumentException {
        try {
            DataHolder holder = this.getDataHolder(name);
            if (holder instanceof Document) {
                return (Document)holder;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchDocumentException(name);
    }

    public List<Property> getProperties() {
        Collection<DataHolder> holders = this.dataStorage.values();
        ArrayList<Property> ret = new ArrayList<Property>();
        for (DataHolder h : holders) {
            if (!(h instanceof Property)) continue;
            ret.add((Property)h);
        }
        return ret;
    }

    public <D extends Document> DocumentList<D> getDocumentList(String name) {
        try {
            DataHolder holder = this.getDataHolder(name);
            if (holder instanceof DocumentList) {
                return (DocumentList)holder;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchDocumentListException(name);
    }

    public Property getProperty(String name) throws NoSuchPropertyException {
        try {
            DataHolder holder = this.getDataHolder(name);
            if (holder instanceof Property) {
                return (Property)holder;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "Property");
    }

    public IntProperty getIntProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof IntProperty) {
                return (IntProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "IntProperty");
    }

    public LongProperty getLongProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof LongProperty) {
                return (LongProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException e) {
            throw new NoSuchPropertyException(name, "LongProperty");
        }
        throw new NoSuchPropertyException(name, "LongProperty");
    }

    public StringProperty getStringProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof StringProperty) {
                return (StringProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "StringProperty");
    }

    public BooleanProperty getBooleanProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof BooleanProperty) {
                return (BooleanProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "BooleanProperty");
    }

    public ListProperty getListProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof ListProperty) {
                return (ListProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "ListProperty");
    }

    public FloatProperty getFloatProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof FloatProperty) {
                return (FloatProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "FloatProperty");
    }

    public DoubleProperty getDoubleProperty(String name) throws NoSuchPropertyException {
        try {
            Property aProperty = this.getProperty(name);
            if (aProperty instanceof DoubleProperty) {
                return (DoubleProperty)aProperty;
            }
        }
        catch (NoSuchDataHolderException noSuchDataHolderException) {
            // empty catch block
        }
        throw new NoSuchPropertyException(name, "DoubleProperty");
    }

    protected <D extends Document> DocumentList<D> getDocumentListAnyCase(String name) {
        try {
            return this.getDocumentList(name);
        }
        catch (NoSuchDocumentListException noSuchDocumentListException) {
            DocumentList<D> newList = this.createDocumentList(name);
            this.putList(newList);
            return newList;
        }
    }

    protected Document getDocumentAnyCase(String name) {
        try {
            return this.getDocument(name);
        }
        catch (NoSuchDocumentException noSuchDocumentException) {
            Document newDoc = this.createDocument(name);
            this.putDocument(newDoc);
            return newDoc;
        }
    }

    protected ListProperty getListPropertyAnyCase(String name) {
        try {
            return this.getListProperty(name);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            ListProperty list = new ListProperty(name);
            this.putProperty(list);
            return list;
        }
    }

    protected <D extends Document> DocumentList<D> createDocumentList(String name) {
        return new DocumentList(name);
    }

    protected Document createDocument(String name) {
        return new Document(name);
    }

    protected ListProperty createListProperty(String name) {
        return new ListProperty(name);
    }

    protected void removeDataHolder(DataHolder holder) {
        this.dataStorage.remove(holder.getId());
    }

    protected void removeDataHolder(String id) {
        this.dataStorage.remove(id);
    }

    protected void addDataHolder(DataHolder holder) {
        this.dataStorage.put(holder.getId(), holder);
    }

    public void putStringProperty(StringProperty p) {
        this.putProperty(p);
    }

    public void putIntProperty(IntProperty p) {
        this.putProperty(p);
    }

    public void putLongProperty(LongProperty p) {
        this.putProperty(p);
    }

    public void putBooleanProperty(BooleanProperty p) {
        this.putProperty(p);
    }

    public void putListProperty(ListProperty p) {
        this.putProperty(p);
    }

    public void putFloatProperty(FloatProperty p) {
        this.putProperty(p);
    }

    public void putDoubleProperty(DoubleProperty p) {
        this.putProperty(p);
    }

    public void putProperty(Property p) {
        this.addDataHolder(p);
    }

    public void removeProperty(Property p) {
        this.removeDataHolder(p);
    }

    public void removeProperty(String propertyName) {
        this.removeDataHolder(propertyName);
    }

    public void putDocument(Document doc) {
        this.addDataHolder(doc);
    }

    public void putList(DocumentList<? extends Document> list) {
        this.addDataHolder(list);
    }

    public String toString() {
        return "DOC " + this.getId() + " " + this.dataStorage;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.dataStorage.keys();
    }

    @Override
    public Object getObject(String key) {
        return this.dataStorage.get(key);
    }

    @Override
    public String getStorageId() {
        return "doc$" + this.getId();
    }

    public String getTypeIdentifier() {
        return this.getString(PROP_TYPE_IDENTIFIER);
    }

    public void setTypeIdentifier(String anIdentifier) {
        this.setString(PROP_TYPE_IDENTIFIER, anIdentifier);
    }

    public String getString(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getStringProperty(fieldId).getString();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyString();
        }
    }

    public long getLong(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getLongProperty(fieldId).getlong();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyLong();
        }
    }

    public int getInt(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getIntProperty(fieldId).getInt();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyInt();
        }
    }

    public List<Property> getList(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getListProperty(fieldId).getList();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyList();
        }
    }

    public float getFloat(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getFloatProperty(fieldId).getfloat();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyFloat();
        }
    }

    public double getDouble(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getDoubleProperty(fieldId).getdouble();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyDouble();
        }
    }

    public boolean getBoolean(String fieldId) throws NoSuchPropertyException {
        try {
            return this.getBooleanProperty(fieldId).getboolean();
        }
        catch (NoSuchPropertyException e) {
            return this.getEmptyBoolean();
        }
    }

    public void setList(String fieldId, List<Property> value) {
        this.putListProperty(new ListProperty(fieldId, value));
    }

    public void setString(String fieldId, String value) {
        this.putStringProperty(new StringProperty(fieldId, value));
    }

    public void setLong(String fieldId, long value) {
        this.putLongProperty(new LongProperty(fieldId, value));
    }

    public void setInt(String fieldId, int value) {
        this.putIntProperty(new IntProperty(fieldId, value));
    }

    public void setFloat(String fieldId, float value) {
        this.putFloatProperty(new FloatProperty(fieldId, value));
    }

    public void setDouble(String fieldId, double value) {
        this.putDoubleProperty(new DoubleProperty(fieldId, value));
    }

    public void setBoolean(String fieldId, boolean value) {
        this.putBooleanProperty(new BooleanProperty(fieldId, value));
    }

    public String getEmptyString() {
        return "";
    }

    public long getEmptyLong() {
        return 0L;
    }

    public int getEmptyInt() {
        return 0;
    }

    public float getEmptyFloat() {
        return 0.0f;
    }

    public double getEmptyDouble() {
        return 0.0;
    }

    public boolean getEmptyBoolean() {
        return false;
    }

    public List<Property> getEmptyList() {
        return new ArrayList<Property>();
    }

    @Override
    public long getSizeInBytes() {
        int sum = 0;
        Enumeration<DataHolder> values = this.dataStorage.elements();
        while (values.hasMoreElements()) {
            sum = (int)((long)sum + values.nextElement().getSizeInBytes());
        }
        return sum;
    }

    public void renameTo(String newId) {
        this.setId(newId);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object ret = super.clone();
        ((Document)ret).dataStorage = (Hashtable)this.dataStorage.clone();
        return ret;
    }

    @Override
    public XMLNode toXMLNode() {
        XMLNode root = new XMLNode("document");
        root.addAttribute(new XMLAttribute("documentId", this.getId()));
        Iterator<DataHolder> it = this.dataStorage.values().iterator();
        while (it.hasNext()) {
            root.addChildNode(it.next().toXMLNode());
        }
        return root;
    }

    public Object getPropertyValue(String propertyName) {
        return this.getProperty(propertyName).getValue();
    }

    public void setLastUpdateNow() {
        this.setLong(PROP_LAST_UPDATE, System.currentTimeMillis());
    }

    public long getLastUpdateTimestamp() {
        return this.getLong(PROP_LAST_UPDATE);
    }

    public void setCallContextAuthor() {
        CallContext callContext = ContextManager.getCallContext();
        String author = callContext != null ? callContext.getCurrentAuthor() : "UNKNOWN";
        this.setString(PROP_AUTHOR, author);
    }

    public String getAuthor() {
        return this.getString(PROP_AUTHOR);
    }

    protected List<String> copyToStringList(List<Property> properties) {
        ArrayList<String> ret = new ArrayList<String>(properties.size());
        for (Property p : properties) {
            ret.add(((StringProperty)p).getString());
        }
        return ret;
    }

    protected List<Property> copyFromStringList(List<String> strings) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (String s : strings) {
            ret.add(new StringProperty(s, s));
        }
        return ret;
    }

    protected List<Integer> copyToIntegerList(List<Property> properties) {
        ArrayList<Integer> ret = new ArrayList<Integer>(properties.size());
        for (Property p : properties) {
            ret.add(((IntProperty)p).getInt());
        }
        return ret;
    }

    protected List<Property> copyFromIntegerList(List<Integer> integers) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (int i : integers) {
            ret.add(new IntProperty("" + i, i));
        }
        return ret;
    }

    protected List<Long> copyToLongList(List<Property> properties) {
        ArrayList<Long> ret = new ArrayList<Long>(properties.size());
        for (Property p : properties) {
            ret.add(((LongProperty)p).getLong());
        }
        return ret;
    }

    protected List<Property> copyFromLongList(List<Long> longs) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (long l : longs) {
            ret.add(new LongProperty("" + l, l));
        }
        return ret;
    }

    protected List<Boolean> copyToBooleanList(List<Property> properties) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>(properties.size());
        for (Property p : properties) {
            ret.add(((BooleanProperty)p).getBoolean());
        }
        return ret;
    }

    protected List<Property> copyFromBooleanList(List<Boolean> booleans) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (boolean b : booleans) {
            ret.add(new BooleanProperty("" + b, b));
        }
        return ret;
    }

    protected List<Double> copyToDoubleList(List<Property> properties) {
        ArrayList<Double> ret = new ArrayList<Double>(properties.size());
        for (Property p : properties) {
            ret.add(((DoubleProperty)p).getDouble());
        }
        return ret;
    }

    protected List<Property> copyFromDoubleList(List<Double> doubles) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (double d : doubles) {
            ret.add(new DoubleProperty("" + d, d));
        }
        return ret;
    }

    protected List<Float> copyToFloatList(List<Property> properties) {
        ArrayList<Float> ret = new ArrayList<Float>(properties.size());
        for (Property p : properties) {
            ret.add(((FloatProperty)p).getFloat());
        }
        return ret;
    }

    protected List<Property> copyFromFloatList(List<Float> floats) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (float d : floats) {
            ret.add(new FloatProperty("" + d, d));
        }
        return ret;
    }
}

