/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import net.anotheria.anodoc.data.DataHolder;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.IBasicStoreableObject;
import net.anotheria.anodoc.data.ICompositeDataObject;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;

public class DocumentList<D extends Document>
extends DataHolder
implements ICompositeDataObject {
    private static final long serialVersionUID = -6201606233792279067L;
    private ArrayList<D> list = new ArrayList();

    public DocumentList(String name) {
        super(name);
    }

    public D getDocumentAt(int pos) {
        return (D)((Document)this.list.get(pos));
    }

    public void addDocument(D doc) {
        this.list.add(doc);
    }

    public List<D> getList() {
        return this.list;
    }

    public void removeDocument(D doc) {
        this.list.remove(doc);
    }

    public void removeDocumentAt(int pos) {
        this.list.remove(pos);
    }

    public boolean containsDocument(String id) {
        for (Document d : this.list) {
            if (!d.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public D getDocumentById(String id) {
        for (int i = 0; i < this.list.size(); ++i) {
            Document doc = (Document)this.list.get(i);
            if (!doc.getId().equals(id)) continue;
            return (D)doc;
        }
        throw new NoSuchDocumentException(id);
    }

    public void insertDocumentAt(D doc, int pos) {
        this.list.add(pos, doc);
    }

    public void removeDocumentById(String id) {
        for (int i = 0; i < this.list.size(); ++i) {
            Document doc = (Document)this.list.get(i);
            if (!doc.getId().equals(id)) continue;
            this.list.remove(i);
            break;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        Vector<Object> keys = new Vector<Object>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            IBasicStoreableObject obj = (IBasicStoreableObject)this.list.get(i);
            Object key = obj.getStorageId();
            key = i + "$" + (String)key;
            keys.add(key);
        }
        return keys.elements();
    }

    public D getObject(String key) {
        String intKey = key.substring(0, key.indexOf(36));
        return (D)((Document)this.list.get(Integer.parseInt(intKey)));
    }

    @Override
    public String getStorageId() {
        return "list$" + this.getId();
    }

    public String toString() {
        return "LST " + this.getId() + ": " + this.list;
    }

    public int getElementCount() {
        return this.list.size();
    }

    @Override
    public long getSizeInBytes() {
        int sum = 0;
        if (this.list == null) {
            return sum;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            sum = (int)((long)sum + ((DataHolder)this.list.get(i)).getSizeInBytes());
        }
        return sum;
    }

    @Override
    public XMLNode toXMLNode() {
        XMLNode root = new XMLNode("documentlist");
        root.addAttribute(new XMLAttribute("listId", this.getId()));
        for (Document d : this.list) {
            root.addChildNode(d.toXMLNode());
        }
        return root;
    }
}

