/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.PropertyType;

public class FloatProperty
extends Property {
    private static final long serialVersionUID = -8097948895367514824L;

    public FloatProperty(String name, float value) {
        this(name, new Float(value));
    }

    public FloatProperty(String name, Float value) {
        super(name, value);
    }

    public Float getFloat() {
        return (Float)this.getValue();
    }

    public float getfloat() {
        return this.getFloat().floatValue();
    }

    public void setFloat(float aValue) {
        this.setFloat(new Float(aValue));
    }

    public void setFloat(Float aValue) {
        super.setValue(aValue);
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Float) {
            super.setValue(o);
            return;
        }
        if (o instanceof String) {
            try {
                super.setValue(new Float((String)o));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException(o + " is not a legal value for FloatProperty");
    }

    @Override
    public long getSizeInBytes() {
        return 8L;
    }

    @Override
    protected Object cloneValue() {
        return new Float(this.getfloat());
    }

    @Override
    public PropertyType getPropertyType() {
        return PropertyType.FLOAT;
    }
}

