/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.PropertyType;

public class IntProperty
extends Property {
    private static final long serialVersionUID = -3202712780342418714L;

    public IntProperty(String name, int value) {
        this(name, (Integer)value);
    }

    public IntProperty(String name, Integer value) {
        super(name, value);
    }

    public Integer getInteger() {
        return (Integer)this.getValue();
    }

    public int getInt() {
        return this.getInteger();
    }

    public void setInt(int aValue) {
        this.setInteger(aValue);
    }

    public void setInteger(Integer aValue) {
        super.setValue(aValue);
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Integer) {
            super.setValue(o);
            return;
        }
        if (o instanceof String) {
            try {
                super.setValue(Integer.valueOf((String)o));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException(o + " is not a legal value for IntProperty");
    }

    @Override
    public long getSizeInBytes() {
        return 4L;
    }

    @Override
    protected Object cloneValue() {
        return new Integer(this.getInt());
    }

    @Override
    public PropertyType getPropertyType() {
        return PropertyType.INT;
    }
}

