/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.PropertyType;
import net.anotheria.util.xml.XMLNode;

public class ListProperty
extends Property {
    private static final long serialVersionUID = -8714197156967135129L;

    public ListProperty(String name) {
        super(name, new ArrayList());
    }

    public ListProperty(String name, List<Property> aList) {
        super(name, aList);
    }

    public List<Property> getList() {
        return (List)this.getValue();
    }

    public Property get(int index) {
        return this.getList().get(index);
    }

    public void add(int index, Property p) {
        this.getList().set(index, p);
    }

    public void add(Property p) {
        this.getList().add(p);
    }

    public void remove(Property p) {
        this.getList().remove(p);
    }

    public void remove(int index) {
        this.getList().remove(index);
    }

    @Override
    public long getSizeInBytes() {
        long sum = 0L;
        int mySize = this.getList().size();
        for (int i = 0; i < mySize; ++i) {
            sum += this.get(i).getSizeInBytes();
        }
        return sum;
    }

    public List<Object> getListData() {
        List<Property> propertyList = this.getList();
        ArrayList<Object> ret = new ArrayList<Object>(propertyList.size());
        for (int i = 0; i < propertyList.size(); ++i) {
            Property p = propertyList.get(i);
            ret.add(p.getValue());
        }
        return ret;
    }

    @Override
    protected Object cloneValue() throws CloneNotSupportedException {
        List<Property> src = this.getList();
        ArrayList<Property> ret = new ArrayList<Property>(src.size());
        Iterator<Property> it = src.iterator();
        while (it.hasNext()) {
            ret.add((Property)it.next().clone());
        }
        return ret;
    }

    @Override
    public XMLNode toXMLNode() {
        XMLNode elem = super.toXMLNode();
        elem.setContent("");
        for (Property p : this.getList()) {
            elem.addChildNode(p.toXMLNode());
        }
        return elem;
    }

    @Override
    public PropertyType getPropertyType() {
        return PropertyType.LIST;
    }
}

