/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.anotheria.anodoc.data.DataHolder;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IBasicStoreableObject;
import net.anotheria.anodoc.data.ICompositeDataObject;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.service.IModuleFactory;
import net.anotheria.anodoc.util.KeyUtility;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Module
implements ICompositeDataObject,
Serializable {
    private String id;
    private Hashtable<String, DataHolder> holders;
    private String ownerId;
    private String copyId;
    private transient Logger log;
    private static final long serialVersionUID = 4896753471545492611L;
    private IModuleFactory moduleFactory;
    private static final char DELIMITER = '$';

    protected Logger getLog() {
        return this.log;
    }

    public Module(String anId) {
        this.id = anId;
        this.holders = new Hashtable();
        this.getLog();
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public Document getDocument(String name) throws NoSuchDocumentException {
        DataHolder doc = this.getDataHolder(name);
        if (doc == null || !(doc instanceof Document)) {
            throw new NoSuchDocumentException(name);
        }
        return (Document)doc;
    }

    public <D extends Document> DocumentList<D> getList(String name) throws NoSuchDocumentListException {
        DataHolder list = this.getDataHolder(name);
        if (list == null || !(list instanceof DocumentList)) {
            throw new NoSuchDocumentListException(name);
        }
        return (DocumentList)list;
    }

    public void putList(DocumentList aList) {
        this.putDataHolder(aList);
    }

    public void putDocument(Document aDoc) {
        this.putDataHolder(aDoc);
    }

    private void putDataHolder(DataHolder holder) {
        this.holders.put(holder.getId(), holder);
    }

    private DataHolder getDataHolder(String key) {
        return this.holders.get(key);
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getId() {
        return this.id;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public void setCopyId(String copyId) {
        this.copyId = copyId;
    }

    public String toString() {
        return "Module:" + this.getId() + "$" + this.ownerId + "$" + this.copyId;
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<DataHolder> allObjects = this.holders.elements();
        Vector<String> keys = new Vector<String>();
        while (allObjects.hasMoreElements()) {
            IBasicStoreableObject o = (IBasicStoreableObject)((Object)allObjects.nextElement());
            keys.add(o.getStorageId());
        }
        return keys.elements();
    }

    @Override
    public Object getObject(String key) {
        String myKey = key.substring(key.indexOf(36) + 1);
        return this.holders.get(myKey);
    }

    @Override
    public String getStorageId() {
        return this.id + "$" + this.ownerId + "$" + this.copyId;
    }

    public void fillFromContainer(Hashtable container) {
        this.log.debug("Filling from container, this:" + this + " container:" + container);
        Enumeration e = container.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object subContainer = container.get(key);
            DataHolder assembledData = null;
            if (KeyUtility.isDocument(key)) {
                assembledData = this.assembleDocument(key, subContainer, null);
            }
            try {
                if (KeyUtility.isList(key)) {
                    assembledData = this.assembleList(key, subContainer);
                }
            }
            catch (Exception ex) {
                this.log.warn("Couldn't assemble " + key + " cause: " + ex.getMessage());
            }
            if (assembledData == null) {
                this.log.warn("Unsupported assemblee with key: " + key);
                continue;
            }
            this.putDataHolder(assembledData);
        }
        this.log.info("Assembled module:" + this);
    }

    private Document assembleDocument(String key, Object o, DataHolder context) {
        Hashtable myContainer = (Hashtable)o;
        String myName = KeyUtility.getDocumentName(key);
        this.log.info("Assembling document with name:" + myName);
        Document doc = context == null ? this.moduleFactory.createDocument(myName) : this.moduleFactory.createDocument(myName, context);
        Enumeration e = myContainer.keys();
        while (e.hasMoreElements()) {
            String aKey = (String)e.nextElement();
            Object anObj = myContainer.get(aKey);
            if (anObj instanceof Property) {
                doc.putProperty((Property)anObj);
                continue;
            }
            Hashtable tmp = (Hashtable)anObj;
            DataHolder containedHolder = null;
            containedHolder = tmp.containsKey("__type_identifier__") && ((StringProperty)tmp.get("__type_identifier__")).getString().equals("doc") ? this.assembleDocument(aKey, anObj, doc) : this.assembleList(aKey, anObj);
            doc.addDataHolder(containedHolder);
        }
        return doc;
    }

    private DocumentList assembleList(String key, Object o) {
        Hashtable myContainer = (Hashtable)o;
        String myName = KeyUtility.getDocumentName(key);
        this.log.info("Assembling list with name:" + myName);
        DocumentList<Document> list = this.moduleFactory.createDocumentList(myName);
        Enumeration e = myContainer.keys();
        Document[] arr = new Document[myContainer.size()];
        while (e.hasMoreElements()) {
            Document doc;
            String aKey = (String)e.nextElement();
            Object anObj = myContainer.get(aKey);
            int pos = Integer.parseInt(KeyUtility.getListPos(aKey));
            String docKey = KeyUtility.getKeyFromListKey(aKey);
            arr[pos] = doc = this.assembleDocument(docKey, anObj, list);
        }
        for (int i = 0; i < arr.length; ++i) {
            list.addDocument(arr[i]);
        }
        return list;
    }

    public IModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    public void setModuleFactory(IModuleFactory myFactory) {
        this.moduleFactory = myFactory;
    }

    public long getStatisticalInformation() {
        return -1L;
    }

    public long getSizeInBytes() {
        Enumeration<DataHolder> dataHolders = this.holders.elements();
        long sum = 0L;
        while (dataHolders.hasMoreElements()) {
            sum += dataHolders.nextElement().getSizeInBytes();
        }
        return sum;
    }

    public Enumeration<String> getHolderNames() {
        return this.holders.keys();
    }

    protected IDHolder _getIdHolder(String docName) {
        try {
            IDHolder h = (IDHolder)this.getDocument(docName);
            return h;
        }
        catch (NoSuchDocumentException noSuchDocumentException) {
            return new IDHolder(docName);
        }
    }

    public XMLNode toXMLNode() {
        XMLNode root = new XMLNode("module");
        root.addAttribute(new XMLAttribute("moduleId", this.getId()));
        root.addAttribute(new XMLAttribute("copyId", this.getCopyId()));
        root.addAttribute(new XMLAttribute("ownerId", this.getOwnerId()));
        root.addAttribute(new XMLAttribute("size", "" + this.getSizeInBytes()));
        Collection<DataHolder> myDataHolders = this.holders.values();
        for (DataHolder dh : myDataHolders) {
            root.addChildNode(dh.toXMLNode());
        }
        return root;
    }
}

