/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.DataHolder;
import net.anotheria.anodoc.data.IPlainDataObject;
import net.anotheria.anodoc.data.PropertyType;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;

public abstract class Property
extends DataHolder
implements IPlainDataObject,
Cloneable {
    private static final long serialVersionUID = -4170023770710073469L;
    private Object value;

    protected Property(String name) {
        this(name, null);
    }

    protected Property(String name, Object aValue) {
        super(name);
        this.value = aValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public String toString() {
        return this.getPropertyType().getIndicator() + this.getName() + "=" + this.value;
    }

    @Override
    public String getStorageId() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Property)) {
            return false;
        }
        Property anotherProperty = (Property)o;
        return this.getName().equals(anotherProperty.getName()) && this.value.equals(anotherProperty.value);
    }

    protected String getName() {
        return this.getId();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Property newP = (Property)super.clone();
        newP.setValue(this.cloneValue());
        return newP;
    }

    public Property cloneAs(String newName) throws CloneNotSupportedException {
        Property newP = (Property)super.clone();
        newP.setValue(this.cloneValue());
        newP.setId(newName);
        return newP;
    }

    protected abstract Object cloneValue() throws CloneNotSupportedException;

    @Override
    public XMLNode toXMLNode() {
        XMLNode ret = new XMLNode("property");
        ret.addAttribute(new XMLAttribute("name", this.getName()));
        ret.addAttribute(new XMLAttribute("type", this.getPropertyType().toString()));
        ret.setContent("" + this.getValue());
        return ret;
    }

    public abstract PropertyType getPropertyType();
}

