/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.anodoc.data.DoubleProperty;
import net.anotheria.anodoc.data.FloatProperty;
import net.anotheria.anodoc.data.IntProperty;
import net.anotheria.anodoc.data.ListProperty;
import net.anotheria.anodoc.data.LongProperty;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.data.TextProperty;
import net.anotheria.util.StringUtils;

public enum PropertyType {
    INT('I', IntProperty.class),
    LONG('L', LongProperty.class),
    DOUBLE('D', DoubleProperty.class),
    FLOAT('F', FloatProperty.class),
    LIST('[', ListProperty.class),
    STRING('S', StringProperty.class),
    TEXT('T', TextProperty.class),
    BOOLEAN('B', BooleanProperty.class);

    private char indicator;
    private final Class<? extends Property> clazz;

    private PropertyType(char anIndicator, Class<? extends Property> cls) {
        this.indicator = anIndicator;
        this.clazz = cls;
    }

    public Class<? extends Property> getClazz() {
        return this.clazz;
    }

    public char getIndicator() {
        return this.indicator;
    }

    public static PropertyType byName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name is not valid");
        }
        return PropertyType.valueOf(name);
    }
}

