/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.data;

import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.PropertyType;

public class StringProperty
extends Property {
    private static final long serialVersionUID = -7506812728258106500L;

    public StringProperty(String name) {
        this(name, null);
    }

    public StringProperty(String name, String value) {
        super(name, value);
    }

    public String getString() {
        return (String)this.getValue();
    }

    public void setString(String aString) {
        this.setValue(aString);
    }

    @Override
    public void setValue(Object o) {
        super.setValue("" + o);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StringProperty) {
            StringProperty p = (StringProperty)obj;
            return p.getName().equals(this.getName()) && p.getValue().equals(this.getValue());
        }
        return false;
    }

    @Override
    public long getSizeInBytes() {
        String s = this.getString();
        return s == null ? 0L : (long)(s.length() * 2);
    }

    @Override
    protected Object cloneValue() {
        return this.getString() != null ? new String(this.getString()) : null;
    }

    @Override
    public PropertyType getPropertyType() {
        return PropertyType.STRING;
    }
}

