/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.query2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;

public class QueryContainsProperty<T>
extends QueryProperty {
    private static final long serialVersionUID = -8649073486730051958L;

    public QueryContainsProperty(String aName, T ... aValues) {
        this(aName, (Collection<T>)Arrays.asList(aValues));
    }

    public QueryContainsProperty(String aName, Collection<T> aValues) {
        super(aName, aValues);
    }

    @Override
    public boolean doesMatch(Object o) {
        if (o == null) {
            return this.getOriginalValue() == null;
        }
        List properties = (List)o;
        HashSet<Object> toCompare = new HashSet<Object>();
        for (Property p : properties) {
            toCompare.add(p.getValue());
        }
        return toCompare.containsAll(this.getListValue());
    }

    @Override
    public String getComparator() {
        return " @> ";
    }

    @Override
    public Object getValue() {
        Collection<T> values = this.getListValue();
        return StringUtils.surroundWith((String)StringUtils.concatenateTokens(values, (char)',', (char)'\'', (char)'\''), (char)'(', (char)')');
    }

    private Collection<T> getListValue() {
        return (Collection)this.getOriginalValue();
    }

    @Override
    public boolean unprepaireable() {
        return true;
    }
}

