/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.query2.string;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.string.StringMatchingInfo;
import net.anotheria.asg.data.DataObject;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsStringQuery
implements DocumentQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainsStringQuery.class);
    public static final int OFFSET = 40;
    public static final String ANY_STRING_EXPRESSION = "*";
    public static final String ANY_STRING_REG_EXPRESSION = "\\*";
    private String criteria;
    private Pattern criteriaRegExPattern;
    private Pattern criteriaMatchRegExPattern;

    public ContainsStringQuery(String aCriteria) {
        this.criteria = aCriteria;
        String criteriaRegEx = aCriteria.replaceAll(ANY_STRING_REG_EXPRESSION, ".*");
        String criteriaMatchRegEx = aCriteria;
        if (criteriaMatchRegEx.startsWith(ANY_STRING_EXPRESSION)) {
            criteriaMatchRegEx = criteriaMatchRegEx.substring(ANY_STRING_EXPRESSION.length());
        }
        if (criteriaMatchRegEx.endsWith(ANY_STRING_EXPRESSION)) {
            criteriaMatchRegEx = criteriaMatchRegEx.substring(0, criteriaMatchRegEx.length() - ANY_STRING_EXPRESSION.length());
        }
        criteriaMatchRegEx = criteriaMatchRegEx.replaceAll(ANY_STRING_REG_EXPRESSION, ".*");
        try {
            this.criteriaRegExPattern = Pattern.compile(criteriaRegEx, 2);
            this.criteriaMatchRegExPattern = Pattern.compile(criteriaMatchRegEx, 2);
        }
        catch (PatternSyntaxException e) {
            LOGGER.warn("PatternSyntaxException: " + e.getMessage());
            try {
                this.criteriaMatchRegExPattern = this.criteriaRegExPattern = Pattern.compile(aCriteria, 2);
            }
            catch (PatternSyntaxException e1) {
                LOGGER.warn("PatternSyntaxException: " + e.getMessage());
                this.criteriaRegExPattern = null;
                this.criteriaMatchRegExPattern = null;
            }
        }
    }

    @Override
    public List<QueryResultEntry> match(DataObject obj) {
        LOGGER.debug("Match DataObject  " + obj.getDefinedName() + " with ID " + obj.getId() + "." + this);
        ArrayList<QueryResultEntry> ret = new ArrayList<QueryResultEntry>();
        if (!(obj instanceof Document) || this.criteriaRegExPattern == null || this.criteriaMatchRegExPattern == null) {
            return ret;
        }
        Document doc = (Document)((Object)obj);
        List<Property> properties = doc.getProperties();
        QueryResultEntry tempEntry = this.getMatchQueryResultEntry(new StringProperty("id", doc.getId()), doc);
        if (tempEntry != null) {
            ret.add(tempEntry);
        }
        for (int i = 0; i < properties.size(); ++i) {
            Property p = properties.get(i);
            tempEntry = this.getMatchQueryResultEntry(p, doc);
            if (tempEntry == null) continue;
            ret.add(tempEntry);
        }
        return ret;
    }

    private QueryResultEntry getMatchQueryResultEntry(Property matchedProperty, Document matchedDocument) {
        if (matchedProperty == null || matchedProperty.getValue() == null) {
            return null;
        }
        String value = matchedProperty.getValue().toString();
        if (StringUtils.isEmpty((String)value) || !this.criteriaRegExPattern.matcher(value).find()) {
            return null;
        }
        QueryResultEntry retEntry = new QueryResultEntry();
        retEntry.setMatchedDocument(matchedDocument);
        retEntry.setMatchedProperty(matchedProperty);
        Matcher matchMatcher = this.criteriaMatchRegExPattern.matcher(value);
        String pre = "";
        String match = value;
        String post = "";
        if (matchMatcher.find()) {
            pre = value.substring(0, matchMatcher.start());
            match = matchMatcher.group();
            post = value.substring(matchMatcher.end());
        }
        retEntry.setInfo(new StringMatchingInfo(pre, match, post));
        return retEntry;
    }

    public String toString() {
        return "ContainsStringQuery [criteria=" + this.criteria + ", criteriaMatchRegExPattern=" + this.criteriaMatchRegExPattern + ", criteriaRegExPattern=" + this.criteriaRegExPattern + "]";
    }
}

