/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.query2.string;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.asg.data.DataObject;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsWordsQuery
implements DocumentQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainsWordsQuery.class);
    public static final Map<String, String> WORDS_SEPARATORS = new HashMap<String, String>();
    private String[] criteria;
    private Set<String> propertiesToSearch = Collections.emptySet();

    public ContainsWordsQuery(String aCriteria) {
        this(aCriteria, new String[0]);
    }

    public ContainsWordsQuery(String aCriteria, String ... aPropertiesToSearch) {
        aCriteria = aCriteria.toLowerCase().trim();
        aCriteria = StringUtils.replace((String)aCriteria, WORDS_SEPARATORS);
        this.criteria = StringUtils.tokenize((String)aCriteria, (char)' ');
        this.propertiesToSearch = new HashSet<String>();
        for (String prop : aPropertiesToSearch) {
            this.propertiesToSearch.add(prop);
        }
    }

    @Override
    public List<QueryResultEntry> match(DataObject obj) {
        LOGGER.debug("Match DataObject  " + obj.getDefinedName() + " with ID " + obj.getId() + "." + this);
        if (!(obj instanceof Document)) {
            throw new AssertionError((Object)"Supports only search in a Document instance!");
        }
        return this.match((Document)((Object)obj));
    }

    public List<QueryResultEntry> match(Document doc) {
        ArrayList<QueryResultEntry> ret = new ArrayList<QueryResultEntry>();
        List<Property> properties = doc.getProperties();
        HashSet<String> matchRegression = new HashSet<String>(Arrays.asList(this.criteria));
        int i = 0;
        for (Property p : properties) {
            ++i;
            Index propertyIndex = this.buildPropertyIndex(p);
            HashSet<String> toRemove = new HashSet<String>();
            for (String match : matchRegression) {
                if (!propertyIndex.containsWord(match)) continue;
                toRemove.add(match);
            }
            matchRegression.removeAll(toRemove);
            if (!matchRegression.isEmpty()) continue;
            QueryResultEntry res = new QueryResultEntry();
            res.setMatchedDocument(doc);
            res.setMatchedProperty(p);
            res.setRelevance(100 / i);
            ret.add(res);
            return ret;
        }
        return ret;
    }

    private Index buildPropertyIndex(Property p) {
        Index ret = new Index();
        String valueStr = p.getValue().toString().toLowerCase().trim();
        if (StringUtils.isEmpty((String)valueStr)) {
            return ret;
        }
        valueStr = StringUtils.removeChar((String)valueStr, (char)'\r');
        valueStr = StringUtils.replace((String)valueStr, WORDS_SEPARATORS);
        String[] wordTokens = StringUtils.tokenize((String)valueStr, (boolean)true, (char)' ');
        for (int i = 0; i < wordTokens.length; ++i) {
            String word = wordTokens[i];
            ret.indexWord(word, i + 1);
        }
        return ret;
    }

    public String toString() {
        return "ContainsAllQuery [criteria=" + Arrays.toString(this.criteria) + ", propertiesToSearch=" + this.propertiesToSearch + "]";
    }

    public static void main(String[] args) throws Exception {
        ContainsWordsQuery query = new ContainsWordsQuery("search query indexing matrix \u041d\u043e\u0443\u0442\u0431\u0443\u043a");
        Document doc = new Document("sample");
        String sample = IOUtils.readInputStreamBufferedAsString((InputStream)query.getClass().getClassLoader().getResourceAsStream("sampletext.txt"), (String)"utf-8");
        StringProperty p = new StringProperty("sampleProp1");
        p.setValue(sample);
        doc.putStringProperty(p);
        sample = IOUtils.readInputStreamBufferedAsString((InputStream)query.getClass().getClassLoader().getResourceAsStream("sampletext2.txt"), (String)"utf-8");
        p = new StringProperty("sampleProp2");
        p.setValue(sample);
        doc.putStringProperty(p);
        p = new StringProperty("sampleProp3");
        p.setValue(null);
        doc.putStringProperty(p);
        System.out.println("** RESULT: **");
        List<QueryResultEntry> result = query.match(doc);
        System.out.println(result);
    }

    static {
        WORDS_SEPARATORS.put("\n", " ");
        WORDS_SEPARATORS.put("\t", " ");
        WORDS_SEPARATORS.put(".", " ");
        WORDS_SEPARATORS.put(",", " ");
        WORDS_SEPARATORS.put("!", " ");
        WORDS_SEPARATORS.put("?", " ");
        WORDS_SEPARATORS.put("-", " ");
        WORDS_SEPARATORS.put("_", " ");
    }

    private static class Occurrenece {
        private Set<Integer> positions = new HashSet<Integer>();

        public Occurrenece(int aFirstPosition) {
            this.positions.add(aFirstPosition);
        }

        public void addOccurrence(int position) {
            this.positions.add(position);
        }

        public boolean containsPosistion(int position) {
            return this.positions.contains(position);
        }

        public String toString() {
            return "Occurrenece [positions=" + this.positions + "]";
        }
    }

    public static class Index {
        Map<String, Occurrenece> index = new HashMap<String, Occurrenece>();
        int size = 0;

        public void indexWord(String word, int position) {
            if (this.index.containsKey(word)) {
                this.index.get(word).addOccurrence(position);
            } else {
                this.index.put(word, new Occurrenece(position));
            }
            this.size = Math.max(this.size, position);
        }

        public boolean containsWord(String word) {
            return this.index.containsKey(word);
        }

        public Occurrenece getWordOccuerrence(String word) {
            return this.index.get(word);
        }

        public String rebuildText() {
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i <= this.size; ++i) {
                for (String word : this.index.keySet()) {
                    Occurrenece occurrenece = this.index.get(word);
                    if (!occurrenece.containsPosistion(i)) continue;
                    builder.append(word).append(" ");
                }
            }
            return builder.toString();
        }

        public String toString() {
            return "Index [size=" + this.size + ", index=" + this.index + "]";
        }
    }
}

