/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.query2.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.string.StringMatchingInfo;
import net.anotheria.asg.data.DataObject;

public class SimpleContainsStringQuery
implements DocumentQuery {
    public static final int OFFSET = 40;
    private String criteria;
    private Set<String> propertiesToSearch = Collections.emptySet();

    public SimpleContainsStringQuery(String aCriteria) {
        this(aCriteria, null);
    }

    public SimpleContainsStringQuery(String aCriteria, Collection<String> aPropertiesToSearch) {
        this.criteria = aCriteria.toLowerCase();
        HashSet<String> emptyProperties = Collections.emptySet();
        this.propertiesToSearch = aPropertiesToSearch != null ? new HashSet<String>(aPropertiesToSearch) : emptyProperties;
    }

    @Override
    public List<QueryResultEntry> match(DataObject obj) {
        ArrayList<QueryResultEntry> ret = new ArrayList<QueryResultEntry>();
        if (!(obj instanceof Document)) {
            throw new AssertionError((Object)"Supports only search in a Document instance!");
        }
        Document doc = (Document)((Object)obj);
        List<Property> properties = doc.getProperties();
        for (Property p : properties) {
            String post;
            String value;
            int index;
            if (this.propertiesToSearch.size() > 0 && !this.propertiesToSearch.contains(p.getId()) || (index = (value = p.getValue().toString()).toLowerCase().indexOf(this.criteria)) == -1) continue;
            QueryResultEntry e = new QueryResultEntry();
            e.setMatchedDocument(doc);
            e.setMatchedProperty(p);
            String pre = value.substring(0, index);
            if (pre.length() > 40) {
                pre = pre.substring(pre.length() - 40, pre.length());
            }
            if ((post = value.substring(index + this.criteria.length(), value.length())).length() > 40) {
                post = post.substring(0, 40);
            }
            e.setInfo(new StringMatchingInfo(pre, value.substring(index, index + this.criteria.length()), post));
            ret.add(e);
        }
        return ret;
    }

    public String toString() {
        return this.criteria;
    }
}

