/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.service;

import java.io.Serializable;
import net.anotheria.anodoc.data.DataHolder;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.service.IModuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleFactory
implements IModuleFactory,
Serializable {
    private static final long serialVersionUID = 1580293076199614251L;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    protected AbstractModuleFactory() {
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public Document createDocument(String name, DataHolder context) {
        this.getLog().debug("This Factory doesn't overwrite create document with context (Doc:" + name + ", context:" + context + ")");
        this.getLog().debug("will call createDocument(name) instead.");
        return this.createDocument(name);
    }

    @Override
    public Document createDocument(String name, String typeIdentifier) {
        this.getLog().debug("This Factory doesn't overwrite create document with identifier (Doc:" + name + ", identifier:" + typeIdentifier + ")");
        this.getLog().debug("will call createDocument(name) instead.");
        return this.createDocument(name);
    }

    @Override
    public Document createDocument(String id) {
        if (id.startsWith("anodoc.id.holder.")) {
            return new IDHolder(id);
        }
        this.getLog().debug("This Factory doesn't overwrite create document (docname:" + id + ")");
        return new Document(id);
    }

    @Override
    public <D extends Document> DocumentList<D> createDocumentList(String name, DataHolder context) {
        this.getLog().debug("This Factory doesn't overwrite create document list(listname:" + name + ")");
        return new DocumentList(name);
    }

    @Override
    public <D extends Document> DocumentList<D> createDocumentList(String name) {
        this.getLog().debug("This Factory doesn't overwrite create document list(listname:" + name + ")");
        return new DocumentList(name);
    }

    @Override
    public final Module createModule(String ownerId, String copyId) {
        Module module = this.recreateModule(ownerId, copyId);
        module.setOwnerId(ownerId);
        module.setCopyId(copyId);
        return module;
    }

    public abstract Module recreateModule(String var1, String var2);
}

