/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.service;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockHolder.class);
    private static ReadWriteLock lock = new ReentrantReadWriteLock();

    private LockHolder() {
    }

    public static void prepareForSave() {
        lock.readLock().lock();
    }

    public static void notifySaved() {
        lock.readLock().unlock();
    }

    private static void blockAll() {
        lock.writeLock().lock();
    }

    public static final void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("Shutdown detecting, blocking writing threads");
                LockHolder.blockAll();
                LOGGER.info("Proceeding with shutdown");
            }
        });
    }
}

