/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.service.IModuleFactory;
import net.anotheria.anodoc.service.IModuleService;
import net.anotheria.anodoc.service.IModuleStorage;
import net.anotheria.anodoc.service.LockHolder;
import net.anotheria.anodoc.service.NoFactoryForModuleException;
import net.anotheria.anodoc.service.NoStorageForModuleException;
import net.anotheria.anodoc.service.NoStoredModuleEntityException;
import net.anotheria.anodoc.service.StorageFailureException;
import net.anotheria.asg.util.listener.IModuleListener;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="anodoc.storage")
public class ModuleServiceImpl
implements IModuleService,
IModuleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleServiceImpl.class);
    private static final String DELIMITER = "#";
    public static final String DEFAULT_COPY_ID = "singlecopy";
    private Map<String, IModuleFactory> factories = new ConcurrentHashMap<String, IModuleFactory>();
    private Map<String, IModuleListener> moduleListeners;
    private Map<String, IModuleStorage> storages = new ConcurrentHashMap<String, IModuleStorage>();
    private Map<String, Module> cache = new ConcurrentHashMap<String, Module>();
    private static ModuleServiceImpl instance = new ModuleServiceImpl();

    protected static ModuleServiceImpl getInstance() {
        return instance;
    }

    private ModuleServiceImpl() {
        this.moduleListeners = new ConcurrentHashMap<String, IModuleListener>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created new ModuleServiceImplementation");
        }
        ConfigurationManager.INSTANCE.configure((Object)this);
    }

    @Override
    public void attachModuleFactory(String moduleId, IModuleFactory factory) {
        this.factories.put(moduleId, factory);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attached module factory " + factory + " for moduleId:" + moduleId);
        }
    }

    @Override
    public void attachModuleStorage(String moduleId, IModuleStorage storage) {
        this.storages.put(moduleId, storage);
        storage.addModuleListener(this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attached module storage " + storage + " for moduleId:" + moduleId);
        }
    }

    private void putInCache(Module module) {
        String key = this.getKey(module);
        this.cache.put(key, module);
    }

    private void removeFromCache(String moduleId, String ownerId, String copyId) {
        String key = this.getKey(moduleId, copyId, ownerId);
        this.cache.remove(key);
    }

    private Module getModuleFromCache(Module module) {
        String key = this.getKey(module);
        Module cachedModule = this.cache.get(key);
        return cachedModule;
    }

    private void putInCacheDirty(Module module) throws NoStorageForModuleException, StorageFailureException {
        this.putInCache(module);
        IModuleStorage storage = this.storages.get(module.getId());
        if (storage == null) {
            LOGGER.warn("No storage for " + module.getId() + ", " + module + " is not persistent!");
            throw new NoStorageForModuleException(module.getId());
        }
        storage.saveModule(module);
    }

    private void removeFromCacheDirty(String moduleId, String ownerId, String copyId) throws NoStorageForModuleException, StorageFailureException {
        this.removeFromCache(moduleId, ownerId, copyId);
        IModuleStorage storage = this.storages.get(moduleId);
        if (storage == null) {
            throw new NoStorageForModuleException(moduleId);
        }
        storage.deleteModule(ownerId, copyId);
    }

    @Override
    public Module getModule(String ownerId, String moduleId, String copyId) throws NoStorageForModuleException, NoFactoryForModuleException, NoStoredModuleEntityException, StorageFailureException {
        return this.getModule(ownerId, moduleId, copyId, false);
    }

    @Override
    public Module getModule(String ownerId, String moduleId) throws NoStorageForModuleException, NoFactoryForModuleException, NoStoredModuleEntityException, StorageFailureException {
        return this.getModule(ownerId, moduleId, DEFAULT_COPY_ID, false);
    }

    @Override
    public Module getModule(String ownerId, String moduleId, boolean create) throws NoStorageForModuleException, NoFactoryForModuleException, NoStoredModuleEntityException, StorageFailureException {
        return this.getModule(ownerId, moduleId, DEFAULT_COPY_ID, create);
    }

    @Override
    public Module getModule(String ownerId, String moduleId, String copyId, boolean create) throws NoStorageForModuleException, NoFactoryForModuleException, NoStoredModuleEntityException, StorageFailureException {
        String key = this.getKey(moduleId, copyId, ownerId);
        Module module = this.cache.get(key);
        if (module != null) {
            LOGGER.debug("Module " + key + " was in cache");
            return module;
        }
        try {
            LOGGER.debug("Trying to load module from storage:" + key);
            module = this.loadModule(moduleId, ownerId, copyId);
            LOGGER.debug("Loaded module from storage.");
            this.putInCache(module);
            return module;
        }
        catch (NoStoredModuleEntityException e) {
            if (create) {
                LOGGER.debug("Creating new instance of " + moduleId + ", " + ownerId + ", " + copyId);
                module = this.createModule(moduleId, ownerId, copyId);
                module.setOwnerId(ownerId);
                module.setCopyId(copyId);
                this.putInCacheDirty(module);
                return module;
            }
            LOGGER.debug("Loading failed:", (Throwable)e);
            throw e;
        }
    }

    private Module loadModule(String moduleId, String ownerId, String copyId) throws NoStorageForModuleException, NoStoredModuleEntityException, StorageFailureException {
        IModuleStorage storage = this.storages.get(moduleId);
        if (storage == null) {
            throw new NoStorageForModuleException(moduleId);
        }
        return storage.loadModule(ownerId, copyId);
    }

    private Module createModule(String moduleId, String ownerId, String copyId) throws NoFactoryForModuleException {
        IModuleFactory factory = this.factories.get(moduleId);
        if (factory == null) {
            throw new NoFactoryForModuleException(moduleId);
        }
        return factory.createModule(ownerId, copyId);
    }

    @Override
    public void storeModule(Module module) throws NoStorageForModuleException, StorageFailureException {
        try {
            LockHolder.prepareForSave();
            this.putInCacheDirty(module);
        }
        finally {
            LockHolder.notifySaved();
        }
    }

    private String getKey(String moduleId, String copyId, String ownerId) {
        return copyId + DELIMITER + moduleId + DELIMITER + ownerId;
    }

    private String getKey(Module module) {
        return this.getKey(module.getId(), module.getCopyId(), module.getOwnerId());
    }

    @Override
    public void deleteModule(Module module) throws NoStorageForModuleException, StorageFailureException {
        this.deleteModule(module.getOwnerId(), module.getId(), module.getCopyId());
    }

    @Override
    public void deleteModule(String ownerId, String moduleId, String copyId) throws NoStorageForModuleException, StorageFailureException {
        this.removeFromCacheDirty(moduleId, ownerId, copyId);
    }

    @Override
    public void deleteModule(String ownerId, String moduleId) throws NoStorageForModuleException, StorageFailureException {
        this.deleteModule(ownerId, moduleId, DEFAULT_COPY_ID);
    }

    @Override
    public void moduleLoaded(Module module) {
        LOGGER.info("Persistence changed for " + module);
        this.removeFromCache(module.getId(), module.getOwnerId(), module.getCopyId());
        IModuleListener listener = this.moduleListeners.get(this.getKey(module.getId(), DEFAULT_COPY_ID, module.getOwnerId()));
        if (listener != null) {
            try {
                listener.moduleLoaded(module);
            }
            catch (Exception e) {
                LOGGER.warn("Caught uncaught exception by the listener " + listener + ", contentChanged()", (Throwable)e);
            }
        }
    }

    @Override
    public void addModuleListener(String moduleId, String ownerId, IModuleListener aModuleListeners) {
        String key = this.getKey(moduleId, DEFAULT_COPY_ID, ownerId);
        this.moduleListeners.put(key, aModuleListeners);
    }

    @Override
    public void removeModuleListener(String moduleId, String ownerId) {
        this.moduleListeners.remove(this.getKey(moduleId, DEFAULT_COPY_ID, ownerId));
    }

    @AfterConfiguration
    public void notifyConfigurationFinished() {
        LOGGER.info("Cleaning cache.");
        this.cache.clear();
    }
}

