/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anodoc.data.IBasicStoreableObject;
import net.anotheria.anodoc.data.ICompositeDataObject;
import net.anotheria.anodoc.data.IPlainDataObject;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.service.IModuleFactory;
import net.anotheria.anodoc.service.IModuleStorage;
import net.anotheria.anodoc.service.NoStoredModuleEntityException;
import net.anotheria.anodoc.util.FileWatcher;
import net.anotheria.anodoc.util.KeyUtility;
import net.anotheria.asg.util.listener.IModuleListener;
import net.anotheria.util.IOUtils;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="anodoc.storage")
public class CommonHashtableModuleStorage
implements IModuleStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonHashtableModuleStorage.class);
    public static final String DEF_KEY_CFG_STORAGE_DIRECTORY = "storage.dir";
    private Hashtable<String, Module> storage;
    private String filename;
    private IModuleFactory factory;
    private String cfgKeyStorageDir;
    public static final String DEF_STORAGE_DIR = ".";
    @Configure
    private String storageDir = ".";
    private static final long FILE_CHECK_PERIOD = 5000L;
    private FileWatcher fileWatchingTimer;
    private List<IModuleListener> listeners = new CopyOnWriteArrayList<IModuleListener>();

    public CommonHashtableModuleStorage(String aFilename, IModuleFactory aFactory) {
        this(aFilename, aFactory, DEF_KEY_CFG_STORAGE_DIRECTORY);
    }

    public CommonHashtableModuleStorage(String aFilename, IModuleFactory aFactory, String aCfgKeyStorageDir) {
        this.storage = new Hashtable();
        this.filename = aFilename;
        this.factory = aFactory;
        this.cfgKeyStorageDir = aCfgKeyStorageDir;
        ConfigurationManager.INSTANCE.configure((Object)this);
    }

    @Override
    public Module loadModule(String ownerId, String copyId) throws NoStoredModuleEntityException {
        String key = this.makeKey(ownerId, copyId);
        if (!this.storage.containsKey(key)) {
            throw new NoStoredModuleEntityException(key);
        }
        return this.storage.get(key);
    }

    @Override
    public void saveModule(Module module) {
        this.storage.put(this.makeKey(module), module);
        this.save();
    }

    @Override
    public void deleteModule(String ownerId, String copyId) {
        String key = this.makeKey(ownerId, copyId);
        this.storage.remove(key);
        this.save();
    }

    private void saveObject(String asKey, IBasicStoreableObject o, Hashtable<String, Hashtable> target) {
        if (o instanceof ICompositeDataObject) {
            this.saveComposite(asKey, (ICompositeDataObject)o, target);
        } else {
            this.savePlain((IPlainDataObject)o, target);
        }
    }

    private void saveComposite(String asKey, ICompositeDataObject c, Hashtable<String, Hashtable> target) {
        Hashtable<String, Hashtable> mySubTarget = new Hashtable<String, Hashtable>();
        Enumeration<String> e = c.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            IBasicStoreableObject obj = (IBasicStoreableObject)c.getObject(key);
            this.saveObject(key, obj, mySubTarget);
        }
        target.put(asKey, mySubTarget);
    }

    private void savePlain(IPlainDataObject o, Hashtable target) {
        target.put(o.getStorageId(), o);
    }

    private void printObject(IBasicStoreableObject o, int tab) {
        System.out.print(this.makeTab(tab) + o.getStorageId() + ": ");
        if (o instanceof ICompositeDataObject) {
            this.printComposite((ICompositeDataObject)o, tab);
        } else {
            this.printPlain((IPlainDataObject)o);
        }
    }

    private void printComposite(ICompositeDataObject c, int tabs) {
        System.out.println("composite");
        Enumeration<String> e = c.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            IBasicStoreableObject obj = (IBasicStoreableObject)c.getObject(key);
            this.printObject(obj, tabs + 1);
        }
    }

    private void printPlain(IPlainDataObject o) {
        System.out.println(o);
    }

    private String makeTab(int tab) {
        Object s = "";
        for (int i = 0; i < tab; ++i) {
            s = (String)s + " ";
        }
        return s;
    }

    private String makeKey(Module m) {
        LOGGER.debug("key " + m.getOwnerId() + "#" + m.getCopyId());
        return this.makeKey(m.getOwnerId(), m.getCopyId());
    }

    private String makeKey(String ownerId, String copyId) {
        return ownerId + "#" + copyId;
    }

    private String parseOwnerId(String key) {
        return key.substring(0, key.indexOf(35));
    }

    private String parseCopyId(String key) {
        return key.substring(key.indexOf(35) + 1);
    }

    protected String getFile(String aFilename) {
        return this.storageDir + File.separator + aFilename;
    }

    protected String getFileLock(String aFilename) {
        String fileLock = this.getFile("locks" + File.separator + aFilename);
        return fileLock.substring(0, fileLock.lastIndexOf(DEF_STORAGE_DIR)) + ".lock";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        LOGGER.info("Saving modules...");
        Enumeration<String> allKeys = this.storage.keys();
        Hashtable<String, Hashtable> toSave = new Hashtable<String, Hashtable>(this.storage.size());
        while (allKeys.hasMoreElements()) {
            String aKey = allKeys.nextElement();
            Module module = this.storage.get(aKey);
            Hashtable<String, Hashtable> moduleTarget = new Hashtable<String, Hashtable>();
            this.saveObject("module", module, moduleTarget);
            Hashtable moduleContainer = moduleTarget.get("module");
            toSave.put(this.makeKey(module), moduleContainer);
        }
        ObjectOutputStream oOut = null;
        try {
            oOut = new ObjectOutputStream(new FileOutputStream(this.getFile(this.filename)));
            oOut.writeObject(toSave);
            IOUtils.closeIgnoringException((Closeable)oOut);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("save", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeIgnoringException(oOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load() {
        block11: {
            ObjectInputStream oIn = null;
            try {
                oIn = new ObjectInputStream(new FileInputStream(this.getFile(this.filename)));
                Hashtable convertedStorage = (Hashtable)oIn.readObject();
                this.storage.clear();
                Enumeration e = convertedStorage.keys();
                while (e.hasMoreElements()) {
                    String aKey = (String)e.nextElement();
                    Hashtable holder = (Hashtable)convertedStorage.get(aKey);
                    String ownerId = this.parseOwnerId(aKey);
                    String copyId = this.parseCopyId(aKey);
                    Module createdModule = this.factory.createModule(ownerId, copyId);
                    createdModule.setModuleFactory(this.factory);
                    createdModule.fillFromContainer(holder);
                    this.storage.put(aKey, createdModule);
                }
                IOUtils.closeIgnoringException((Closeable)oIn);
            }
            catch (FileNotFoundException ignorable) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("FileNotFound " + this.filename + ", assuming new installation");
                }
                for (String key : this.storage.keySet()) {
                    Module module = this.storage.get(key);
                    Module createdModule = this.factory.createModule(module.getOwnerId(), module.getCopyId());
                    createdModule.setModuleFactory(this.factory);
                    this.storage.put(key, createdModule);
                }
                this.save();
                IOUtils.closeIgnoringException((Closeable)oIn);
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("load", (Throwable)e);
                }
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeIgnoringException(oIn);
            }
        }
    }

    private void printStorage(Hashtable holder) {
        System.err.println("======= PRINT STORAGE =======");
        Enumeration e = holder.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.err.println("Key:" + key);
            String toPrint = "Key:" + key + " is a ";
            if (KeyUtility.isDocument(key)) {
                toPrint = toPrint + "document";
            }
            if (KeyUtility.isList(key)) {
                toPrint = toPrint + "list";
            }
            System.err.println(toPrint);
            System.err.println("\t" + holder.get(key));
        }
    }

    public void setStorageDir(String value) {
        this.storageDir = value;
    }

    @Override
    public void addModuleListener(IModuleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModuleListener(IModuleListener listener) {
        this.listeners.remove(listener);
    }

    private void firePersistenceChangedEvent() {
        this.load();
        for (IModuleListener listener : this.listeners) {
            for (Module changed : this.storage.values()) {
                try {
                    listener.moduleLoaded(changed);
                }
                catch (Exception e) {
                    LOGGER.error("Caught uncaught exception by the listener " + listener + ", moduleLoaded(" + changed + ")", (Throwable)e);
                }
            }
        }
    }

    private void startFileWatcherTask() {
        if (this.fileWatchingTimer != null) {
            this.fileWatchingTimer.stop();
        }
        this.fileWatchingTimer = new FileWatcher(this.getFileLock(this.filename), 5000L){

            @Override
            protected void onChange() {
                LOGGER.info("content of modules in " + CommonHashtableModuleStorage.this.getFile(CommonHashtableModuleStorage.this.filename) + " has been changed");
                CommonHashtableModuleStorage.this.firePersistenceChangedEvent();
            }
        };
        this.fileWatchingTimer.start();
    }

    @AfterConfiguration
    public void notifyConfigurationFinished() {
        this.load();
        this.startFileWatcherTask();
    }
}

