/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.util;

import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.service.IModuleFactory;
import net.anotheria.anodoc.service.IModuleStorage;
import net.anotheria.anodoc.service.NoStoredModuleEntityException;
import net.anotheria.anodoc.service.StorageFailureException;
import net.anotheria.anodoc.util.CommonModuleStorageException;
import net.anotheria.anodoc.util.ICommonModuleStorage;
import net.anotheria.asg.util.listener.IModuleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonModuleStorageWrapper
implements IModuleStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonModuleStorageWrapper.class);
    private String moduleId;
    private IModuleFactory factory;
    private ICommonModuleStorage delegate;

    public CommonModuleStorageWrapper(String aModuleId, IModuleFactory aFactory, ICommonModuleStorage aDelegate) {
        this.moduleId = aModuleId;
        this.factory = aFactory;
        this.delegate = aDelegate;
    }

    @Override
    public void saveModule(Module module) throws StorageFailureException {
        try {
            this.delegate.saveModule(module);
        }
        catch (CommonModuleStorageException e) {
            LOGGER.warn("saveModule", (Throwable)e);
            throw new StorageFailureException(e.getMessage());
        }
    }

    @Override
    public Module loadModule(String ownerId, String copyId) throws NoStoredModuleEntityException, StorageFailureException {
        try {
            Module module = this.delegate.loadModule(this.moduleId, ownerId, copyId, this.factory);
            if (module == null) {
                throw new NoStoredModuleEntityException("haeh ??");
            }
            return module;
        }
        catch (NoStoredModuleEntityException e) {
            throw e;
        }
        catch (CommonModuleStorageException e) {
            LOGGER.warn("loadModule", (Throwable)e);
            throw new StorageFailureException(e.getMessage());
        }
    }

    @Override
    public void deleteModule(String ownerId, String copyId) throws StorageFailureException {
        try {
            this.delegate.deleteModule(this.moduleId, ownerId, copyId);
        }
        catch (Exception ex) {
            LOGGER.error("deleteModule", (Throwable)ex);
            throw new StorageFailureException(ex.getMessage());
        }
    }

    @Override
    public void addModuleListener(IModuleListener listener) {
    }

    @Override
    public void removeModuleListener(IModuleListener listener) {
    }
}

