/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.util;

import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public abstract class FileWatcher {
    private String filePath;
    private long period;
    private Timer timer;

    public FileWatcher(String aFilePath, long aPeriod) {
        this.filePath = aFilePath;
        this.period = aPeriod;
    }

    public void start() {
        this.stop();
        this.timer = new Timer("FileWatcher(" + this.filePath + ")", true);
        this.timer.schedule((TimerTask)new FileWatcherTask(this.filePath), this.period, this.period);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    protected abstract void onChange();

    private class FileWatcherTask
    extends TimerTask {
        private File file;

        public FileWatcherTask(String aFilePath) {
            this.file = new File(aFilePath);
        }

        @Override
        public final void run() {
            if (!this.file.exists()) {
                try {
                    this.file.getParentFile().mkdirs();
                    this.file.createNewFile();
                    FileWatcher.this.onChange();
                }
                catch (IOException e) {
                    System.out.println("FileWatcherTask run " + e);
                }
            }
        }
    }
}

