/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anodoc.util.mapper;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.anodoc.data.DoubleProperty;
import net.anotheria.anodoc.data.FloatProperty;
import net.anotheria.anodoc.data.IntProperty;
import net.anotheria.anodoc.data.ListProperty;
import net.anotheria.anodoc.data.LongProperty;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.mapper.pds.BooleanPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.DoublePropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.FloatPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.IntPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.ListPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.LongPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.PropertyDeserializer;
import net.anotheria.anodoc.util.mapper.pds.StringPropertyDeserializer;
import net.anotheria.anodoc.util.mapper.ps.BooleanPropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.DoublePropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.FloatPropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.IntPropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.ListPropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.LongPropertySerializer;
import net.anotheria.anodoc.util.mapper.ps.StringPropertySerializer;

public final class ObjectMapperUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static Module createCustomModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BooleanProperty.class, (JsonSerializer)new BooleanPropertySerializer());
        module.addSerializer(DoubleProperty.class, (JsonSerializer)new DoublePropertySerializer());
        module.addSerializer(FloatProperty.class, (JsonSerializer)new FloatPropertySerializer());
        module.addSerializer(IntProperty.class, (JsonSerializer)new IntPropertySerializer());
        module.addSerializer(ListProperty.class, (JsonSerializer)new ListPropertySerializer());
        module.addSerializer(LongProperty.class, (JsonSerializer)new LongPropertySerializer());
        module.addSerializer(StringProperty.class, (JsonSerializer)new StringPropertySerializer());
        module.addDeserializer(BooleanProperty.class, (JsonDeserializer)new BooleanPropertyDeserializer());
        module.addDeserializer(DoubleProperty.class, (JsonDeserializer)new DoublePropertyDeserializer());
        module.addDeserializer(FloatProperty.class, (JsonDeserializer)new FloatPropertyDeserializer());
        module.addDeserializer(IntProperty.class, (JsonDeserializer)new IntPropertyDeserializer());
        module.addDeserializer(ListProperty.class, (JsonDeserializer)new ListPropertyDeserializer());
        module.addDeserializer(LongProperty.class, (JsonDeserializer)new LongPropertyDeserializer());
        module.addDeserializer(Property.class, (JsonDeserializer)new PropertyDeserializer());
        module.addDeserializer(StringProperty.class, (JsonDeserializer)new StringPropertyDeserializer());
        return module;
    }

    private ObjectMapperUtil() {
    }

    public static ObjectMapper getMapperInstance() {
        return MAPPER;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.registerModule(ObjectMapperUtil.createCustomModule());
    }
}

