/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.data;

import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.anodoc.data.Document;
import net.anotheria.anodoc.data.LongProperty;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.data.ObjectInfo;

public abstract class AbstractASGDocument
extends Document
implements DataObject,
LockableObject {
    protected static final String INT_PROPERTY_MULTILINGUAL_DISABLED = "ml-disabled";

    protected AbstractASGDocument(String anId) {
        super(anId);
    }

    protected AbstractASGDocument(AbstractASGDocument toClone) {
        super(toClone);
    }

    @Override
    public ObjectInfo getObjectInfo() {
        ObjectInfo ret = new ObjectInfo(this);
        ret.setId(this.getId());
        ret.setAuthor(this.getAuthor());
        ret.setLastChangeTimestamp(this.getLastUpdateTimestamp());
        ret.setFootprint(this.getFootprint());
        return ret;
    }

    protected Property getInternalProperty(String name) {
        return this.getProperty(this.getInternalPropertyName(name));
    }

    protected void setInternalProperty(Property p) {
        try {
            Property toPut = p.cloneAs(this.getInternalPropertyName(p.getId()));
            this.putProperty(toPut);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Property not cloneable: " + p + ", clazz: " + p.getClass());
        }
    }

    private String getInternalPropertyName(String name) {
        return "-asg-" + name + "-asg-";
    }

    @Override
    public boolean isLocked() {
        try {
            return ((BooleanProperty)this.getInternalProperty("locked")).getboolean();
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
    }

    @Override
    public void setLocked(boolean aLock) {
        this.setInternalProperty(new BooleanProperty("locked", aLock));
    }

    @Override
    public String getLockerId() {
        try {
            return ((StringProperty)this.getInternalProperty("lockerId")).getString();
        }
        catch (NoSuchPropertyException e) {
            return null;
        }
    }

    @Override
    public void setLockerId(String aLockerId) {
        this.setInternalProperty(new StringProperty("lockerId", aLockerId));
    }

    @Override
    public long getLockingTime() {
        try {
            return ((LongProperty)this.getInternalProperty("lockingTime")).getlong();
        }
        catch (NoSuchPropertyException e) {
            return 0L;
        }
    }

    @Override
    public void setLockingTime(long aLockTime) {
        this.setInternalProperty(new LongProperty("lockingTime", aLockTime));
    }
}

