/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.data;

import net.anotheria.asg.data.DataObject;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;

public class ObjectInfo {
    private String id;
    private String author;
    private long lastChangeTimestamp;
    private String footprint;
    private String type;

    public ObjectInfo() {
    }

    public ObjectInfo(DataObject object) {
        this.setId(object.getId());
        this.setLastChangeTimestamp(object.getLastUpdateTimestamp());
        this.setFootprint(object.getFootprint());
        this.setType(object.getDefinedName());
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public long getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    public void setLastChangeTimestamp(long lastChangeTimestamp) {
        this.lastChangeTimestamp = lastChangeTimestamp;
    }

    public String getFootprint() {
        return this.footprint;
    }

    public void setFootprint(String footprint) {
        this.footprint = footprint;
    }

    public String toString() {
        return "Id: " + this.getId() + ", Ts: " + this.getLastChangeTimestamp() + ", Footprint: " + this.getFootprint() + ", Author: " + this.getAuthor() + ", IsoTs: " + NumberUtils.makeISO8601TimestampString((long)this.getLastChangeTimestamp());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public XMLNode toXML() {
        XMLNode ret = new XMLNode("objectinfo");
        ret.addAttribute(new XMLAttribute("id", this.getId()));
        ret.addChildNode(this.getChildNode("id", this.getId()));
        ret.addChildNode(this.getChildNode("type", this.getType()));
        ret.addChildNode(this.getChildNode("timestamp", "" + this.getLastChangeTimestamp()));
        ret.addChildNode(this.getChildNode("iso8601timestamp", NumberUtils.makeISO8601TimestampString((long)this.getLastChangeTimestamp())));
        ret.addChildNode(this.getChildNode("footprint", this.getFootprint()));
        return ret;
    }

    private XMLNode getChildNode(String name, String text) {
        XMLNode ret = new XMLNode(name);
        ret.setContent(text);
        return ret;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

