/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.data;

import java.util.List;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLNode;

public class XMLHelper {
    public static <T> XMLNode createXMLNodeForListValue(String name, String contentType, List<T> content) {
        XMLNode ret = new XMLNode(name);
        XMLNode val = new XMLNode("value");
        ret.addChildNode(val);
        val.addAttribute(new XMLAttribute("type", "list"));
        val.addAttribute(new XMLAttribute("contentType", contentType));
        for (T c : content) {
            XMLNode el = new XMLNode("element");
            val.addChildNode(el);
            el.setContent("" + c);
        }
        return ret;
    }

    public static XMLNode createXMLNodeForImageValue(String name, String[] language, String ... value) {
        return XMLHelper.createXMLNodeForStringValue(name, language, value);
    }

    public static XMLNode createXMLNodeForTextValue(String name, String[] language, String ... value) {
        return XMLHelper.createXMLNodeForStringValue(name, language, value);
    }

    public static XMLNode createXMLNodeForPasswordValue(String name, String[] language, String ... value) {
        return XMLHelper.createXMLNodeForStringValue(name, language, value);
    }

    public static XMLNode createXMLNodeForStringValue(String name, String[] language, String ... value) {
        return XMLHelper.createXMLNodeWithContent(name, language, "string", value);
    }

    public static XMLNode createXMLNodeForBooleanValue(String name, String[] languages, boolean ... value) {
        return XMLHelper.createXMLNodeWithAttribute(name, languages, "boolean", XMLHelper.makeArray(value));
    }

    public static XMLNode createXMLNodeForIntValue(String name, String[] languages, int ... value) {
        return XMLHelper.createXMLNodeWithAttribute(name, languages, "int", XMLHelper.makeArray(value));
    }

    public static XMLNode createXMLNodeForLongValue(String name, String[] languages, long ... value) {
        return XMLHelper.createXMLNodeWithAttribute(name, languages, "long", XMLHelper.makeArray(value));
    }

    public static XMLNode createXMLNodeForDoubleValue(String name, String[] languages, double ... value) {
        return XMLHelper.createXMLNodeWithAttribute(name, languages, "double", XMLHelper.makeArray(value));
    }

    public static XMLNode createXMLNodeForFloatValue(String name, String[] languages, float ... value) {
        return XMLHelper.createXMLNodeWithAttribute(name, languages, "float", XMLHelper.makeArray(value));
    }

    private static XMLNode createXMLNodeWithContent(String name, String[] languages, String type, Object ... value) {
        XMLNode ret = new XMLNode(name);
        if (languages == null) {
            XMLNode val = new XMLNode("value");
            if (type != null) {
                val.addAttribute(new XMLAttribute("type", type));
            }
            ret.addChildNode(val);
            if (value != null) {
                val.setContent("" + value[0]);
            }
        } else {
            for (int i = 0; i < languages.length; ++i) {
                String l = languages[i];
                XMLNode val = new XMLNode("value");
                if (type != null) {
                    val.addAttribute(new XMLAttribute("type", type));
                }
                val.addAttribute(new XMLAttribute("language", l));
                if (value != null) {
                    String valueToSet = value[i] != null ? value[i] : "";
                    val.setContent(valueToSet);
                }
                ret.addChildNode(val);
            }
        }
        return ret;
    }

    private static XMLNode createXMLNodeWithAttribute(String name, String[] languages, String type, Object ... value) {
        XMLNode ret = new XMLNode(name);
        if (languages == null) {
            XMLNode val = new XMLNode("value");
            if (type != null) {
                val.addAttribute(new XMLAttribute("type", type));
            }
            ret.addChildNode(val);
            if (value != null) {
                val.addAttribute(new XMLAttribute("value", "" + value[0]));
            }
        } else {
            for (int i = 0; i < languages.length; ++i) {
                String l = languages[i];
                System.out.println(l + " -> " + value[i]);
                XMLNode val = new XMLNode("value");
                if (type != null) {
                    val.addAttribute(new XMLAttribute("type", type));
                }
                val.addAttribute(new XMLAttribute("language", l));
                if (value != null) {
                    val.addAttribute(new XMLAttribute("value", "" + value[i]));
                }
                ret.addChildNode(val);
            }
        }
        return ret;
    }

    private static Integer[] makeArray(int[] in) {
        Integer[] out = new Integer[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Long[] makeArray(long[] in) {
        Long[] out = new Long[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Boolean[] makeArray(boolean[] in) {
        Boolean[] out = new Boolean[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Double[] makeArray(double[] in) {
        Double[] out = new Double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private static Float[] makeArray(float[] in) {
        Float[] out = new Float[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Float.valueOf(in[i]);
        }
        return out;
    }

    private XMLHelper() {
    }
}

