/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.GeneratedArtefact;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GenerationJobManager;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaProperty;
import net.anotheria.asg.generator.view.meta.MetaFieldElement;
import net.anotheria.asg.generator.view.meta.MetaViewElement;
import net.anotheria.asg.generator.view.meta.MultilingualFieldElement;
import net.anotheria.util.StringUtils;

public class AbstractGenerator {
    public static final String CRLF = "\n";
    protected int ident = 0;

    protected String quote(String s) {
        return "\"" + s + "\"";
    }

    protected String quote(StringBuilder s) {
        return "\"" + s.toString() + "\"";
    }

    protected String quote(int a) {
        return this.quote("" + a);
    }

    protected String writeIncreasedString(String s) {
        this.increaseIdent();
        String ret = this.writeString(s);
        this.decreaseIdent();
        return ret;
    }

    protected void appendIncreasedString(String ... strings) {
        this.appendIncreasedString(AbstractGenerator.getCurrentJobContent(), strings);
    }

    protected void appendIncreasedString(StringBuilder target, String ... strings) {
        this.increaseIdent();
        this.appendString(target, strings);
        this.decreaseIdent();
    }

    protected String writeIncreasedStatement(String s) {
        return this.writeIncreasedString(s + ";");
    }

    protected void appendIncreasedStatement(String ... strings) {
        this.appendIncreasedStatement(AbstractGenerator.getCurrentJobContent(), strings);
    }

    protected void appendIncreasedStatement(StringBuilder target, String ... strings) {
        this.increaseIdent();
        this.appendStatement(target, strings);
        this.decreaseIdent();
    }

    protected String writeString(String s) {
        Object ret = this.getIdent();
        ret = (String)ret + s;
        ret = (String)ret + CRLF;
        return ret;
    }

    protected void appendString(String ... strings) {
        this.appendString(AbstractGenerator.getCurrentJobContent(), strings);
    }

    protected void appendString(StringBuilder target, String ... strings) {
        this.appendIdent(target);
        for (String s : strings) {
            target.append(s);
        }
        target.append(CRLF);
    }

    protected void openTry() {
        this.appendString("try {");
        this.increaseIdent();
    }

    protected void appendCatch(Class<? extends Throwable> exceptionClazz) {
        ((GeneratedClass)AbstractGenerator.getCurrentJob()).addImport(exceptionClazz);
        this.appendCatch(exceptionClazz.getName());
    }

    protected void appendCatch(String exceptionName) {
        this.decreaseIdent();
        this.appendString("}catch(", exceptionName, " e){");
        this.increaseIdent();
    }

    protected void openFun(String s) {
        if (!((String)s).endsWith("{")) {
            s = (String)s + " {";
        }
        this.appendString(new String[]{s});
        this.increaseIdent();
    }

    protected void appendNullCheck(String aArgName, String aExceptionMessage) {
        ((GeneratedClass)AbstractGenerator.getCurrentJob()).addImport(IllegalArgumentException.class);
        this.appendString("if(" + aArgName + " == null)");
        this.increaseIdent();
        this.appendString("throw new IllegalArgumentException(\"" + aExceptionMessage + "\");");
        this.decreaseIdent();
    }

    protected String writeStatement(String s) {
        Object ret = this.getIdent();
        ret = (String)ret + s;
        ret = (String)ret + ";";
        ret = (String)ret + CRLF;
        return ret;
    }

    protected void append(String ... strings) {
        StringBuilder target = AbstractGenerator.getCurrentJobContent();
        for (String s : strings) {
            target.append(s);
        }
    }

    protected void appendStatement(String ... strings) {
        this.appendStatement(AbstractGenerator.getCurrentJobContent(), strings);
    }

    protected void appendStatement(StringBuilder target, String ... strings) {
        this.appendIdent(target);
        for (String s : strings) {
            target.append(s);
        }
        target.append(';');
        target.append(CRLF);
    }

    private void appendIdent(StringBuilder target) {
        for (int i = 0; i < this.ident; ++i) {
            target.append('\t');
        }
    }

    private String getIdent() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.ident; ++i) {
            ret.append("\t");
        }
        return ret.toString();
    }

    protected void increaseIdent() {
        ++this.ident;
    }

    protected void decreaseIdent() {
        --this.ident;
        if (this.ident < 0) {
            this.ident = 0;
        }
    }

    protected void resetIdent() {
        this.ident = 0;
    }

    public static String writeEmptyline() {
        return CRLF;
    }

    public static void emptyline() {
        AbstractGenerator.getCurrentJobContent().append(CRLF);
    }

    protected static void emptyline(StringBuilder b) {
        b.append(CRLF);
    }

    protected static void appendEmptyline() {
        AbstractGenerator.emptyline(AbstractGenerator.getCurrentJobContent());
    }

    protected String writeImport(String imp) {
        return this.writeString("import " + imp + ";");
    }

    protected void appendImport(String imp) {
        this.appendString(AbstractGenerator.getCurrentJobContent(), "import ", imp, ";");
    }

    protected void appendImport(StringBuilder target, String imp) {
        this.appendString(target, "import ", imp, ";");
    }

    protected String writeImport(String packagename, String classname) {
        return this.writeString("import " + packagename + "." + classname + ";");
    }

    protected void closeBlock(StringBuilder b) {
        this.decreaseIdent();
        b.append(this.writeString("}"));
    }

    @Deprecated
    protected String closeBlock() {
        this.decreaseIdent();
        String ret = this.writeString("}");
        return ret;
    }

    protected void closeBlockNEW() {
        this.decreaseIdent();
        this.appendString("}");
    }

    protected void closeBlock(String message) {
        this.decreaseIdent();
        this.appendString("} //" + message);
    }

    protected void appendMark(int markNumber) {
    }

    protected String writeCommentLine(String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        if (tokens.length != 1) {
            return this.writeComment(commentline);
        }
        String ret = this.writeString("// " + commentline);
        return ret;
    }

    protected String writeComment(String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        Object ret = "";
        ret = (String)ret + this.writeString("/**");
        for (int i = 0; i < tokens.length; ++i) {
            ret = (String)ret + this.writeString(" * " + tokens[i]);
        }
        ret = (String)ret + this.writeString(" */");
        return ret;
    }

    protected void appendCommentLine(String commentline) {
        this.appendCommentLine(AbstractGenerator.getCurrentJobContent(), commentline);
    }

    protected void appendGenerationPoint(String point) {
        this.appendCommentLine("Generated by: " + this.getClass() + "." + point);
        AbstractGenerator.emptyline();
    }

    protected void appendCommentLine(StringBuilder target, String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        if (tokens.length != 1) {
            this.appendComment(target, commentline);
        } else {
            this.appendString(target, "// ", commentline);
        }
    }

    protected void appendComment(String commentline) {
        this.appendComment(AbstractGenerator.getCurrentJobContent(), commentline);
    }

    protected void appendComment(StringBuilder target, String commentline) {
        String[] tokens = StringUtils.tokenize((String)commentline, (char)'\n');
        this.appendString(target, "/**");
        for (int i = 0; i < tokens.length; ++i) {
            this.appendString(target, " * " + tokens[i]);
        }
        this.appendString(target, " */");
    }

    protected static List<MetaViewElement> createMultilingualList(List<MetaViewElement> source, MetaDocument doc) {
        ArrayList<MetaViewElement> ret = new ArrayList<MetaViewElement>();
        for (MetaViewElement e : source) {
            if (e instanceof MetaFieldElement) {
                MetaProperty p = doc.getField(e.getName());
                if (p == null) {
                    System.out.println("Can't find property for filed " + e.getName() + ", skipped");
                    continue;
                }
                if (!p.isMultilingual() || !GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
                    ret.add(e);
                    continue;
                }
                for (String l : GeneratorDataRegistry.getInstance().getContext().getLanguages()) {
                    ret.add(new MultilingualFieldElement(l, (MetaFieldElement)e));
                }
                continue;
            }
            ret.add(e);
        }
        return ret;
    }

    protected String getElementLanguage(MetaViewElement element) {
        return element instanceof MultilingualFieldElement ? ((MultilingualFieldElement)element).getLanguage() : null;
    }

    public final void startNewJob(GeneratedArtefact clazz) {
        GenerationJobManager.startNewJob(clazz);
    }

    public static final StringBuilder getCurrentJobContent() {
        return GenerationJobManager.getCurrentJob().getStringBuilder();
    }

    public static final GeneratedArtefact getCurrentJob() {
        return GenerationJobManager.getCurrentJob().getArtefact();
    }

    protected void startClassBody() {
        this.ident = 1;
    }
}

