/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.service.AbstractASGService;

public class BasicServiceGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaModule> modules) {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(new FileEntry(this.generateBasicService(modules)));
        ret.add(new FileEntry(this.generateBasicCMSService(modules)));
        return ret;
    }

    private GeneratedClass generateBasicService(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".service");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("net.anotheria.anoprise.metafactory.MetaFactory");
        clazz.addImport("net.anotheria.anoprise.metafactory.Extension");
        clazz.addImport("net.anotheria.anoprise.metafactory.MetaFactoryException");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("org.slf4j.MarkerFactory");
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.ModuleName");
        clazz.addImport("net.anotheria.anosite.gen.shared.util.DocumentName");
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        for (MetaModule m : modules) {
            clazz.addImport(ServiceGenerator.getInterfaceImport(m));
        }
        clazz.addImport(AbstractASGService.class);
        clazz.setAbstractClass(true);
        clazz.setName("BasicService");
        clazz.setParent(AbstractASGService.class);
        this.startClassBody();
        this.appendStatement("protected Logger log");
        BasicServiceGenerator.emptyline();
        this.appendStatement("private static Object serviceInstantiationLock = new Object()");
        BasicServiceGenerator.emptyline();
        this.appendCommentLine("CMS instances of different services.");
        for (MetaModule m : modules) {
            this.appendStatement("private static volatile " + ServiceGenerator.getInterfaceName(m) + " " + this.getServiceInstance(m));
        }
        BasicServiceGenerator.emptyline();
        this.appendString("protected BasicService(){");
        this.increaseIdent();
        this.appendStatement("log = LoggerFactory.getLogger(\"AnoSiteLog\")");
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        for (MetaModule m : modules) {
            this.appendString("protected " + ServiceGenerator.getInterfaceName(m) + " " + this.getServiceGetterCall(m) + "{");
            this.increaseIdent();
            this.appendString("if (" + this.getServiceInstance(m) + " == null){");
            this.increaseIdent();
            this.appendString("synchronized(serviceInstantiationLock){");
            this.increaseIdent();
            this.appendString("if (" + this.getServiceInstance(m) + " == null){");
            this.increaseIdent();
            this.appendString("try{");
            this.appendIncreasedStatement(this.getServiceInstance(m) + " = MetaFactory.get(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.EDITORINTERFACE)");
            this.appendString("}catch(MetaFactoryException e){");
            this.appendIncreasedStatement("log.error(MarkerFactory.getMarker(\"FATAL\"), " + this.quote("Can't load editor instance of module service " + m.getName()) + ", e)");
            this.appendString("}");
            this.closeBlockNEW();
            this.closeBlockNEW();
            this.closeBlockNEW();
            this.appendStatement("return " + this.getServiceInstance(m));
            this.closeBlockNEW();
            BasicServiceGenerator.emptyline();
        }
        return clazz;
    }

    private GeneratedClass generateBasicCMSService(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".service");
        clazz.addImport("net.anotheria.anodoc.data.Module");
        clazz.addImport("net.anotheria.anodoc.service.IModuleService");
        clazz.addImport("net.anotheria.anodoc.service.ModuleServiceFactory");
        clazz.addImport("net.anotheria.asg.util.listener.IModuleListener");
        clazz.setName("BasicCMSService");
        clazz.setParent("BasicService");
        clazz.setAbstractClass(true);
        this.startClassBody();
        this.appendStatement("public static final String MY_OWNER_ID = " + this.quote(GeneratorDataRegistry.getInstance().getContext().getOwner()));
        this.appendStatement("protected IModuleService service");
        BasicServiceGenerator.emptyline();
        this.appendString("static{");
        this.increaseIdent();
        this.appendString("AnoDocConfigurator.configure();");
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        this.appendString("protected BasicCMSService(){");
        this.increaseIdent();
        this.appendStatement("service = ModuleServiceFactory.createModuleService()");
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        this.appendString("protected void updateModule(Module mod){");
        this.increaseIdent();
        this.appendString("try{");
        this.appendString("service.storeModule(mod);");
        this.appendString("}catch(Exception e){");
        this.increaseIdent();
        this.appendString("log.error(\"updateModule\", e);");
        this.closeBlockNEW();
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        this.appendString("protected void addModuleListener(String moduleId, IModuleListener moduleListener){");
        this.increaseIdent();
        this.appendString("service.addModuleListener(moduleId, MY_OWNER_ID, moduleListener);");
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        this.appendString("protected Module getModule(String moduleId){");
        this.increaseIdent();
        this.appendString("try{");
        this.appendString("return service.getModule(MY_OWNER_ID, moduleId, true);");
        this.appendString("}catch(Exception e){");
        this.increaseIdent();
        this.appendString("log.error(\"getModule\", e);");
        this.closeBlockNEW();
        this.appendStatement("return null");
        this.closeBlockNEW();
        BasicServiceGenerator.emptyline();
        return clazz;
    }

    private String getServiceGetterCall(MetaModule module) {
        return "get" + module.getName() + "Service()";
    }

    private String getServiceInstance(MetaModule module) {
        return module.getName().toLowerCase() + "Service";
    }
}

