/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Generator;
import net.anotheria.asg.generator.IGenerator;

public class CommentGenerator
extends AbstractGenerator {
    public static final String COPYRIGHT = "Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net";
    public static final String RIGHTS = "All Rights Reserved.";
    public static final String NOTICE_1 = "Don't edit this code, if you aren't sure";
    public static final String NOTICE_2 = "that you do exactly know what you are doing!";
    public static final String NOTICE_3 = "It's better to invest time in the generator, as into the generated code.";
    public static final String LINE_PRE = "*** ";
    public static final String LINE_POST = " ***";
    public static final int LINES_ADD_LENGTH = " ***".length() + "*** ".length();
    public static final String SEPARATOR = "*";
    public static final String COMM_START = "/**";
    public static final String COMM_END = " */";

    public static final String generateJavaTypeComment(String className) {
        return CommentGenerator.generateJavaTypeComment(className, (String)null);
    }

    public static final String generateJavaTypeComment(String className, IGenerator generator) {
        return CommentGenerator.generateJavaTypeComment(className, "Generator: " + generator.getClass().getName());
    }

    public static final String generateJavaTypeComment(String className, String additionalInfo) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!((String)className).endsWith(".java")) {
            className = (String)className + ".java";
        }
        lines.add(null);
        lines.add((String)className);
        if (additionalInfo != null && additionalInfo.length() > 0) {
            lines.add(additionalInfo);
        }
        lines.add("generated by " + Generator.getProductString() + ", Version: " + Generator.getVersionString());
        lines.add(COPYRIGHT);
        lines.add(RIGHTS);
        lines.add(null);
        lines.add(NOTICE_1);
        lines.add(NOTICE_2);
        lines.add(NOTICE_3);
        lines.add(null);
        int longestLineLength = CommentGenerator.findLongestLineLength(lines);
        longestLineLength += LINES_ADD_LENGTH;
        Object separator = "";
        for (int i = 0; i < longestLineLength; ++i) {
            separator = (String)separator + SEPARATOR;
        }
        Object ret = "";
        ret = (String)ret + "/**\n";
        for (int i = 0; i < lines.size(); ++i) {
            Object line = (String)lines.get(i);
            if (line == null) {
                ret = (String)ret + " " + (String)separator + "\n";
                continue;
            }
            while (((String)line).length() < longestLineLength - LINES_ADD_LENGTH) {
                line = (String)line + " ";
            }
            ret = (String)ret + " *** " + (String)line + " ***\n";
        }
        ret = (String)ret + " */\n";
        ret = (String)ret + "\n";
        return ret;
    }

    private static int findLongestLineLength(List<String> lines) {
        int length = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int l;
            String line = lines.get(i);
            if (line == null || (l = line.length()) <= length) continue;
            length = l;
        }
        return length;
    }
}

