/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.apputil.CallContextGenerator;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.ServiceGenerator;

public class ConfiguratorGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable g) {
        return null;
    }

    public static String getConfiguratorClassName() {
        return "AnoDocConfigurator";
    }

    public static String getMetaFactoryConfiguratorClassName() {
        return "MetaFactoryConfigurator";
    }

    public List<FileEntry> generate(List<MetaModule> modules) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        entries.add(this.generateConfigurator(modules));
        entries.add(this.generateMetaFactoryConfigurator(modules));
        return entries;
    }

    private FileEntry generateMetaFactoryConfigurator(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setGenerator(this);
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(MetaModule.SHARED));
        clazz.setName(ConfiguratorGenerator.getMetaFactoryConfiguratorClassName());
        clazz.addImport(Extension.class);
        clazz.addImport(MetaFactory.class);
        for (MetaModule mod : modules) {
            if (!this.isRMIEnabled(mod)) continue;
            clazz.addImport(GeneratorDataRegistry.getInstance().getContext().getServicePackageName(mod) + ".rmi.RMI" + ServiceGenerator.getFactoryName(mod));
        }
        this.startClassBody();
        this.appendStatement("private static volatile boolean configured");
        ConfiguratorGenerator.emptyline();
        this.appendString("public static void configure(){");
        this.increaseIdent();
        this.appendString("if (configured)");
        this.increaseIdent();
        this.appendString("return;");
        this.decreaseIdent();
        this.appendString("configured = true;");
        for (int i = 0; i < modules.size(); ++i) {
            MetaModule m = modules.get(i);
            clazz.addImport(ServiceGenerator.getInterfaceImport(m));
            clazz.addImport(ServiceGenerator.getFactoryImport(m));
            this.appendCommentLine("//aliases for " + ServiceGenerator.getInterfaceName(m));
            this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.LOCAL)");
            this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.DOMAIN, Extension.LOCAL)");
            this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.DOMAIN, Extension.EDITORINTERFACE)");
            if (m.getStorageType() == StorageType.CMS) {
                this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.CMS, Extension.DOMAIN)");
                this.appendStatement("MetaFactory.addFactoryClass(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.CMS, " + ServiceGenerator.getFactoryName(m) + ".class)");
            }
            if (m.getStorageType() == StorageType.DB) {
                this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.DB, Extension.DOMAIN)");
                this.appendStatement("MetaFactory.addFactoryClass(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.DB, " + ServiceGenerator.getFactoryName(m) + ".class)");
            }
            if (m.getStorageType() == StorageType.FEDERATION) {
                this.appendStatement("MetaFactory.addAlias(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.FEDERATION, Extension.DOMAIN)");
                this.appendStatement("MetaFactory.addFactoryClass(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.FEDERATION, " + ServiceGenerator.getFactoryName(m) + ".class)");
            }
            if (!this.isRMIEnabled(m)) continue;
            this.appendStatement("MetaFactory.addFactoryClass(" + ServiceGenerator.getInterfaceName(m) + ".class, Extension.REMOTE, RMI" + ServiceGenerator.getFactoryName(m) + ".class)");
        }
        this.append(this.closeBlock());
        ConfiguratorGenerator.emptyline();
        this.openFun("public static void deInit()");
        this.appendString("configured = false;");
        this.closeBlock("");
        return new FileEntry(clazz);
    }

    private boolean isRMIEnabled(MetaModule m) {
        return m.getModuleOptions() != null && m.getModuleOptions().isEnabled("rmi");
    }

    private FileEntry generateConfigurator(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        Context context = GeneratorDataRegistry.getInstance().getContext();
        clazz.setPackageName(context.getServicePackageName(MetaModule.SHARED));
        clazz.addImport("net.anotheria.anodoc.service.IModuleFactory");
        clazz.addImport("net.anotheria.anodoc.service.IModuleService");
        clazz.addImport("net.anotheria.anodoc.service.ModuleServiceFactory");
        clazz.addImport("net.anotheria.anodoc.util.CommonHashtableModuleStorage");
        clazz.setName(ConfiguratorGenerator.getConfiguratorClassName());
        clazz.setGenerator(this);
        this.startClassBody();
        this.appendComment("Returns the selected encoding. Using method instead of constant to prevent compilation dependencies");
        this.appendString("public static final String getEncoding(){ return " + this.quote(GeneratorDataRegistry.getInstance().getContext().getEncoding()) + "; }");
        ConfiguratorGenerator.emptyline();
        this.appendString("private static void addCommonStorage(String moduleId, IModuleService service, IModuleFactory factory, String storageDirConfigKey){");
        this.increaseIdent();
        this.appendString("service.attachModuleFactory(moduleId, factory );");
        this.appendString("if (storageDirConfigKey==null)");
        this.appendIncreasedString("service.attachModuleStorage(moduleId, new CommonHashtableModuleStorage(moduleId+\".dat\", factory));");
        this.appendString("else");
        this.appendIncreasedString("service.attachModuleStorage(moduleId, new CommonHashtableModuleStorage(moduleId+\".dat\", factory, storageDirConfigKey));");
        this.append(this.closeBlock());
        ConfiguratorGenerator.emptyline();
        this.appendStatement("private static volatile boolean configured");
        ConfiguratorGenerator.emptyline();
        this.appendString("public static void configure(){");
        this.increaseIdent();
        this.appendString("if (configured)");
        this.increaseIdent();
        this.appendString("return;");
        this.decreaseIdent();
        this.appendString("configured = true;");
        this.appendString("net.anotheria.anodoc.util.context.ContextManager.setFactory(new " + CallContextGenerator.getFullFactoryName(context) + "());");
        this.appendStatement("IModuleService service = ModuleServiceFactory.createModuleService()");
        for (int i = 0; i < modules.size(); ++i) {
            MetaModule m = modules.get(i);
            clazz.addImport(context.getPackageName(m) + ".data.*");
            if (m.getStorageType() != StorageType.CMS) continue;
            Object call = "addCommonStorage(";
            call = (String)call + m.getModuleClassName() + ".MODULE_ID";
            call = (String)call + ", ";
            call = (String)call + "service";
            call = (String)call + ", ";
            call = (String)call + "new " + m.getFactoryClassName() + "()";
            call = m.getStorageKey() != null ? (String)call + ", " + this.quote(m.getStorageKey()) : (String)call + ", null";
            call = (String)call + ")";
            this.appendStatement(new String[]{call});
        }
        this.appendStatement(ConfiguratorGenerator.getMetaFactoryConfiguratorClassName() + ".configure()");
        this.append(this.closeBlock());
        return new FileEntry(clazz);
    }
}

