/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.generator.ContextParameter;
import net.anotheria.asg.generator.GenerationOptions;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;

public class Context {
    private String packageName;
    private String owner;
    private String applicationName;
    private String servletMapping;
    private String encoding;
    private String applicationURLPath;
    private boolean multilanguageSupport;
    private List<String> languages;
    private String defaultLanguage;
    private GenerationOptions options;
    private Map<String, ContextParameter> parameters = new HashMap<String, ContextParameter>();
    private boolean cmsVersion1 = true;
    private boolean cmsVersion2 = false;

    public String getPackageName() {
        return this.packageName;
    }

    public String getTopPackageName() {
        return this.packageName;
    }

    public String getJspPackageName(MetaDocument doc) {
        return this.getJspPackageName(doc.getParentModule());
    }

    public String getJspPackageName(MetaModule module) {
        return this.getPackageName(module) + ".jsp";
    }

    public String getDataPackageName(MetaDocument doc) {
        return this.getDataPackageName(doc.getParentModule());
    }

    public String getDataPackageName(MetaModule module) {
        return this.getPackageName(module) + ".data";
    }

    public String getServicePackageName(MetaDocument doc) {
        return this.getServicePackageName(doc.getParentModule());
    }

    public String getServicePackageName(MetaModule module) {
        return this.getPackageName(module) + ".service";
    }

    public String getPackageName(MetaModule module) {
        return this.packageName + "." + module.getName().toLowerCase();
    }

    public String getPackageName(MetaDocument doc) {
        return this.getPackageName(doc.getParentModule());
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    public void setServletMapping(String string) {
        this.servletMapping = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public boolean areLanguagesSupported() {
        return this.multilanguageSupport;
    }

    public void enableMultiLanguageSupport() {
        this.multilanguageSupport = true;
        this.languages = new ArrayList<String>();
    }

    public void addLanguage(String l) {
        this.languages.add(l);
    }

    public void addContextParameter(ContextParameter p) {
        this.parameters.put(p.getName(), p);
    }

    public void addContextParameter(String name, String value) {
        this.addContextParameter(new ContextParameter(name, value));
    }

    public List<ContextParameter> getContextParameters() {
        ArrayList<ContextParameter> ret = new ArrayList<ContextParameter>();
        ret.addAll(this.parameters.values());
        return ret;
    }

    public ContextParameter getContextParameter(String name) {
        return this.parameters.get(name);
    }

    public String getApplicationURLPath() {
        return this.applicationURLPath == null || this.applicationURLPath.length() == 0 ? "" : "/" + this.applicationURLPath;
    }

    public void setApplicationURLPath(String applicationURLPath) {
        this.applicationURLPath = applicationURLPath;
    }

    public GenerationOptions getOptions() {
        return this.options;
    }

    public void setOptions(GenerationOptions options) {
        this.options = options;
    }

    public boolean isCmsVersion1() {
        return this.cmsVersion1;
    }

    public void setCmsVersion1(boolean cmsVersion1Generator) {
        this.cmsVersion1 = cmsVersion1Generator;
    }

    public boolean isCmsVersion2() {
        return this.cmsVersion2;
    }

    public void setCmsVersion2(boolean cmsVersion2Generator) {
        this.cmsVersion2 = cmsVersion2Generator;
    }
}

