/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractAnoDocGenerator;
import net.anotheria.asg.generator.BasicServiceGenerator;
import net.anotheria.asg.generator.ConfiguratorGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;
import net.anotheria.asg.generator.model.ModuleGenerator;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.asg.generator.model.db.SQLGenerator;
import net.anotheria.asg.generator.model.docs.ModuleFactoryGenerator;
import net.anotheria.util.ExecutionTimer;

public class DataGenerator
extends AbstractAnoDocGenerator {
    public void generate(String path, List<MetaModule> modules) {
        Context context = GeneratorDataRegistry.getInstance().getContext();
        ArrayList<FileEntry> todo = new ArrayList<FileEntry>();
        ExecutionTimer timer = new ExecutionTimer("DataGenerator");
        timer.startExecution("config");
        todo.addAll(new ConfiguratorGenerator().generate(modules));
        timer.stopExecution("config");
        timer.startExecution("basic service");
        todo.addAll(new BasicServiceGenerator().generate(modules));
        timer.stopExecution("basic service");
        timer.startExecution("sql");
        todo.addAll(new SQLGenerator().generate(modules));
        timer.stopExecution("sql");
        timer.startExecution("modules");
        for (int i = 0; i < modules.size(); ++i) {
            MetaModule m = modules.get(i);
            timer.startExecution(m.getName());
            if (m.getStorageType() == StorageType.CMS) {
                this.runGenerator(new ModuleFactoryGenerator(), m, context, todo);
            }
            timer.startExecution(m.getName() + "-ModuleGen");
            this.runGenerator(new ModuleGenerator(), m, context, todo);
            timer.stopExecution(m.getName() + "-ModuleGen");
            timer.startExecution(m.getName() + "-ServiceGen");
            this.runGenerator(new ServiceGenerator(), m, context, todo);
            timer.stopExecution(m.getName() + "-ServiceGen");
            timer.stopExecution(m.getName());
        }
        timer.stopExecution("modules");
        this.writeFiles(todo);
    }
}

