/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import net.anotheria.asg.generator.GeneratedArtefact;
import net.anotheria.util.StringUtils;

public class FileEntry {
    private String path;
    private String name;
    private String content;
    private String type = ".java";

    public FileEntry() {
    }

    public FileEntry(String aPath, String aName, String aContent, String aType) {
        this();
        this.path = aPath;
        this.name = aName;
        this.content = aContent;
        this.type = aType;
    }

    public FileEntry(String aPath, String aName, String aContent) {
        this();
        this.path = aPath;
        this.name = aName;
        this.content = aContent;
    }

    public FileEntry(GeneratedArtefact artefact) {
        this();
        if (artefact != null) {
            this.path = artefact.getPath();
            this.name = artefact.getName();
            this.type = artefact.getFileType();
            this.content = artefact.createFileContent();
        }
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String toString() {
        return this.path + "/" + this.name;
    }

    public static String package2fullPath(String packageName) {
        return "java/" + FileEntry.package2path(packageName);
    }

    public static String package2path(String packageName) {
        return StringUtils.replace((String)packageName, (char)'.', (char)'/');
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }
}

