/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.CommentGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedArtefact;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.util.StringUtils;

public class GeneratedClass
extends GeneratedArtefact {
    private List<String> imports;
    private List<String> interfaces;
    private List<String> annotations;
    private StringBuilder body;
    private ClassDef parent;
    private String generic;
    private String packageName;
    private String typeComment;
    private String clazzComment;
    private TypeOfClass type = TypeOfClass.getDefault();
    private boolean generateLogger = false;
    private boolean abstractClass = false;
    private IGenerator generator;

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean anAbstractClass) {
        this.abstractClass = anAbstractClass;
    }

    public GeneratedClass() {
        this.body = new StringBuilder();
        this.imports = new ArrayList<String>();
        this.interfaces = new ArrayList<String>();
        this.annotations = new ArrayList<String>();
    }

    public String createClassFileContent() {
        StringBuilder ret = new StringBuilder(this.body.length() + 200);
        if (this.typeComment == null || this.typeComment.length() == 0) {
            this.typeComment = this.generator == null ? CommentGenerator.generateJavaTypeComment(this.getName()) : CommentGenerator.generateJavaTypeComment(this.getName(), this.generator);
        }
        ret.append(this.getTypeComment());
        ret.append("package " + this.getPackageName() + ";");
        ret.append("\n").append("\n");
        for (String imp : this.imports) {
            ret.append("import ").append(imp).append(";").append("\n");
        }
        ret.append("\n");
        if (this.clazzComment != null && this.clazzComment.length() > 0) {
            ret.append("/**").append("\n");
            ret.append(" * ").append(this.clazzComment).append("\n");
            ret.append(" */").append("\n");
        }
        for (String annotation : this.annotations) {
            ret.append(annotation).append("\n");
        }
        String nameDeclaration = "public " + (this.isAbstractClass() ? "abstract " : "") + this.type.toJava() + " " + this.getName();
        if (!StringUtils.isEmpty((String)this.getGeneric())) {
            nameDeclaration = nameDeclaration + " <" + this.getGeneric() + ">";
        }
        if (this.getParent() != null) {
            nameDeclaration = nameDeclaration + " extends " + this.getParent().getNameWithGeneric();
        }
        if (this.interfaces != null && this.interfaces.size() > 0) {
            nameDeclaration = nameDeclaration + " implements ";
            for (int i = 0; i < this.interfaces.size(); ++i) {
                if (i > 0) {
                    nameDeclaration = nameDeclaration + ", ";
                }
                nameDeclaration = nameDeclaration + this.interfaces.get(i);
            }
        }
        ret.append(nameDeclaration).append("{");
        ret.append("\n").append("\n");
        if (this.generateLogger) {
            ret.append("\tprivate static Logger log = LoggerFactory.getLogger(" + this.getName() + ".class);").append("\n").append("\n");
        }
        ret.append((CharSequence)this.getBody());
        ret.append("}").append("\n");
        return ret.toString();
    }

    public void addInterface(String anInterface) {
        if (!this.interfaces.contains(anInterface)) {
            this.interfaces.add(anInterface);
        }
    }

    public void addInterface(Class<?> anInterfaceClazz) {
        if (!anInterfaceClazz.getPackage().getName().equals(this.getPackageName())) {
            this.addImport(anInterfaceClazz);
        }
        this.interfaces.add(this.extractClassName(anInterfaceClazz));
    }

    public void addImport(Class<?> clazz) {
        this.addImport(clazz.getName());
    }

    public void addImport(String anImport) {
        if (!this.imports.contains(anImport)) {
            this.imports.add(anImport);
        }
    }

    public void addAnnotation(String annotation) {
        if (!this.annotations.contains(annotation)) {
            this.annotations.add(annotation);
        }
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public StringBuilder getBody() {
        return this.body;
    }

    public void setBody(StringBuilder aBody) {
        this.body = aBody;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<String> annotations) {
        this.annotations = annotations;
    }

    @Override
    public String createFileContent() {
        return this.createClassFileContent();
    }

    @Override
    public String getFileType() {
        return ".java";
    }

    @Override
    public String getPath() {
        return FileEntry.package2fullPath(this.getPackageName());
    }

    public ClassDef getParent() {
        return this.parent;
    }

    public void setParent(Class<?> parentClazz) {
        if (!parentClazz.getPackage().getName().equals(this.getPackageName())) {
            this.addImport(parentClazz);
        }
        this.setParent(this.extractClassName(parentClazz));
    }

    private String extractClassName(Class<?> aClazz) {
        return aClazz.getName().substring(aClazz.getName().lastIndexOf(46) + 1);
    }

    public void setParent(String aParent) {
        this.parent = new ClassDef(aParent);
    }

    public void setParent(String aParent, String aGeneric) {
        this.parent = new ClassDef(aParent, aGeneric);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String aPackageName) {
        this.packageName = aPackageName;
    }

    public String getTypeComment() {
        return this.typeComment;
    }

    public void setTypeComment(String aTypeComment) {
        this.typeComment = aTypeComment;
    }

    public TypeOfClass getType() {
        return this.type;
    }

    public void setType(TypeOfClass aType) {
        this.type = aType;
    }

    public boolean isGenerateLogger() {
        return this.generateLogger;
    }

    public void setGenerateLogger(boolean aGenerateLogger) {
        if (aGenerateLogger) {
            this.addImport("org.slf4j.Logger");
            this.addImport("org.slf4j.LoggerFactory");
        }
        this.generateLogger = aGenerateLogger;
    }

    public String getClazzComment() {
        return this.clazzComment;
    }

    public void setClazzComment(String aClazzComment) {
        this.clazzComment = aClazzComment;
    }

    public IGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(IGenerator aGenerator) {
        this.generator = aGenerator;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        this.generic = generic;
    }

    public static class ClassDef {
        private String name;
        private String generic;

        public ClassDef(String aName) {
            this.name = aName;
        }

        public ClassDef(String aName, String aGeneric) {
            this.name = aName;
            this.generic = aGeneric;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGeneric() {
            return this.generic;
        }

        public void setGeneric(String generic) {
            this.generic = generic;
        }

        public String getNameWithGeneric() {
            return this.name + (String)(StringUtils.isEmpty((String)this.generic) ? "" : "<" + this.generic + ">");
        }

        public String toString() {
            return this.getName();
        }
    }
}

