/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.DataGenerator;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.apputil.AppUtilGenerator;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.parser.XMLContextParser;
import net.anotheria.asg.generator.parser.XMLDataParser;
import net.anotheria.asg.generator.parser.XMLDecoratorsParser;
import net.anotheria.asg.generator.parser.XMLFiltersParser;
import net.anotheria.asg.generator.parser.XMLPreprocessor;
import net.anotheria.asg.generator.parser.XMLTypesParser;
import net.anotheria.asg.generator.parser.XMLValidatorsParser;
import net.anotheria.asg.generator.parser.XMLViewParser;
import net.anotheria.asg.generator.types.TypesGenerator;
import net.anotheria.asg.generator.types.meta.DataType;
import net.anotheria.asg.generator.util.IncludedDocuments;
import net.anotheria.asg.generator.validation.XMLAgainstXSDValidation;
import net.anotheria.asg.generator.view.ViewGenerator;
import net.anotheria.asg.generator.view.meta.MetaDecorator;
import net.anotheria.asg.generator.view.meta.MetaFilter;
import net.anotheria.asg.generator.view.meta.MetaValidator;
import net.anotheria.asg.generator.view.meta.MetaView;
import net.anotheria.util.NumberUtils;

public class Generator {
    private static String BASE_DIR = "";

    public static void setBaseDir(String dir) {
        BASE_DIR = dir;
    }

    public static String getBaseDir() {
        return BASE_DIR;
    }

    public static void generate() throws Exception {
        long s1 = System.currentTimeMillis();
        IncludedDocuments includedDocuments = new IncludedDocuments();
        String dataContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/datadef.xml"), includedDocuments);
        Generator.validateXML("datadef", dataContent, includedDocuments);
        String viewContent = null;
        long s2 = System.currentTimeMillis();
        try {
            viewContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/editview_def.xml"), includedDocuments);
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        if (viewContent != null) {
            Generator.validateXML("editview_def", viewContent, includedDocuments);
        }
        String contextContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/context.xml"), null);
        Generator.validateXML("context", contextContent, null);
        Context c = XMLContextParser.parseContext(contextContent);
        GeneratorDataRegistry.getInstance().setContext(c);
        long s3 = System.currentTimeMillis();
        try {
            String typesContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/datatypes.xml"), null);
            Generator.validateXML("datatypes", typesContent, null);
            List<DataType> types = XMLTypesParser.parseTypes(typesContent);
            TypesGenerator tg = new TypesGenerator();
            tg.generate("java", types);
            GeneratorDataRegistry.getInstance().addTypes(types);
        }
        catch (Exception typesContent) {
            // empty catch block
        }
        long s4 = System.currentTimeMillis();
        try {
            String decoratorsContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/decorators-def.xml"), null);
            Generator.validateXML("decorators-def", decoratorsContent, null);
            List<MetaDecorator> decorators = XMLDecoratorsParser.parseDecorators(decoratorsContent);
            GeneratorDataRegistry.getInstance().addDecorators(decorators);
        }
        catch (Exception decoratorsContent) {
            // empty catch block
        }
        long s5 = System.currentTimeMillis();
        try {
            String filtersContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/filters-def.xml"), null);
            Generator.validateXML("filters-def", filtersContent, null);
            List<MetaFilter> filters = XMLFiltersParser.parseFilters(filtersContent);
            GeneratorDataRegistry.getInstance().addFilters(filters);
        }
        catch (Exception filtersContent) {
            // empty catch block
        }
        long s6 = System.currentTimeMillis();
        try {
            String validatorsContent = XMLPreprocessor.loadFile(new File(BASE_DIR + "etc/def/validators-def.xml"), null);
            Generator.validateXML("validators-def", validatorsContent, null);
            List<MetaValidator> filters = XMLValidatorsParser.parseValidators(validatorsContent);
            GeneratorDataRegistry.getInstance().addValidators(filters);
        }
        catch (Exception validatorsContent) {
            // empty catch block
        }
        long s7 = System.currentTimeMillis();
        List<MetaModule> modules = XMLDataParser.parseModules(dataContent);
        GeneratorDataRegistry.getInstance().addModules(modules);
        AppUtilGenerator utilGen = new AppUtilGenerator(c);
        utilGen.generate(modules);
        long s8 = System.currentTimeMillis();
        DataGenerator g = new DataGenerator();
        g.generate("java", modules);
        long s9 = System.currentTimeMillis();
        if (viewContent != null) {
            List<MetaView> views = XMLViewParser.parseViews(viewContent);
            GeneratorDataRegistry.getInstance().addViews(views);
            ViewGenerator v = new ViewGenerator();
            v.generate("java", views);
        } else {
            System.out.println("VIEW_CONTENT = NULL");
        }
        System.out.println("DONE.");
        Generator.printTime("Total ", s9, s1);
    }

    private static void printTime(String name, long end, long start) {
        System.out.println(name + ": " + NumberUtils.getDotedNumber((long)(end - start)));
    }

    public static String getVersionString() {
        return "3.2.2";
    }

    public static String getProductString() {
        return "AnoSiteGenerator (ASG)";
    }

    private static void validateXML(String fileName, String fileContent, IncludedDocuments includedDocuments) {
        InputStream inputStream = Generator.class.getResourceAsStream("/schema/" + fileName + ".xsd");
        if (inputStream == null) {
            throw new RuntimeException("File /schema/" + fileName + ".xsd doesn't exist.");
        }
        XMLAgainstXSDValidation.validateAgainstXSDSchema(fileName + ".xml", fileContent, inputStream, includedDocuments);
    }
}

