/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.GenerationOptions;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.types.meta.DataType;
import net.anotheria.asg.generator.util.DirectLink;
import net.anotheria.asg.generator.view.meta.MetaDecorator;
import net.anotheria.asg.generator.view.meta.MetaFilter;
import net.anotheria.asg.generator.view.meta.MetaModuleSection;
import net.anotheria.asg.generator.view.meta.MetaSection;
import net.anotheria.asg.generator.view.meta.MetaValidator;
import net.anotheria.asg.generator.view.meta.MetaView;

public final class GeneratorDataRegistry {
    private static GeneratorDataRegistry instance = new GeneratorDataRegistry();
    private Map<String, MetaModule> modules;
    private Map<String, MetaView> views;
    private Context context;
    private Map<String, DataType> types;
    private Map<String, MetaDecorator> decorators;
    private Map<String, MetaFilter> filters;
    private Map<String, MetaValidator> validators;
    private GenerationOptions defaultOptions = GeneratorDataRegistry.createDefaultGenerationOptions();
    private GenerationOptions options;

    private GeneratorDataRegistry() {
        this.modules = new HashMap<String, MetaModule>();
        this.views = new HashMap<String, MetaView>();
        this.types = new HashMap<String, DataType>();
        this.decorators = new HashMap<String, MetaDecorator>();
        this.filters = new HashMap<String, MetaFilter>();
        this.validators = new HashMap<String, MetaValidator>();
        this.options = this.defaultOptions;
    }

    public static GeneratorDataRegistry getInstance() {
        return instance;
    }

    public void addModule(MetaModule m) {
        this.modules.put(m.getName(), m);
    }

    public void addModules(List<MetaModule> aModules) {
        for (MetaModule m : aModules) {
            this.addModule(m);
        }
    }

    public void addView(MetaView v) {
        this.views.put(v.getName(), v);
    }

    public void addViews(List<MetaView> aViews) {
        for (MetaView v : aViews) {
            this.addView(v);
        }
    }

    public MetaDocument resolveLink(String link) {
        int dotIndex = link.indexOf(46);
        String targetModuleName = link.substring(0, dotIndex);
        String targetDocumentName = link.substring(dotIndex + 1);
        MetaModule mod = this.getModule(targetModuleName);
        MetaDocument targetDocument = mod.getDocumentByName(targetDocumentName);
        return targetDocument;
    }

    public List<DirectLink> findLinksToDocument(MetaDocument target) {
        ArrayList<DirectLink> ret = new ArrayList<DirectLink>();
        for (MetaModule module : this.modules.values()) {
            for (MetaDocument document : module.getDocuments()) {
                List<MetaLink> links = document.getLinksToDocument(target);
                for (MetaLink l : links) {
                    ret.add(new DirectLink(module, document, l));
                }
            }
        }
        return ret;
    }

    public MetaSection findViewSection(MetaDocument document) {
        for (MetaView module : this.views.values()) {
            for (MetaSection section : module.getSections()) {
                if (!(section instanceof MetaModuleSection) || !document.equals(((MetaModuleSection)section).getDocument())) continue;
                return section;
            }
        }
        return null;
    }

    public MetaModule getModule(String name) {
        return this.modules.get(name);
    }

    public Collection<MetaModule> getModules() {
        return this.modules.values();
    }

    public MetaView getView(String name) {
        return this.views.get(name);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
        if (context.getOptions() != null) {
            this.options = context.getOptions();
        }
    }

    public void addType(DataType type) {
        this.types.put(type.getName(), type);
    }

    public void addTypes(List<DataType> aTypes) {
        Iterator<DataType> it = aTypes.iterator();
        while (it.hasNext()) {
            this.addType(it.next());
        }
    }

    public DataType getType(String name) {
        DataType ret = this.types.get(name);
        if (ret == null) {
            RuntimeException e = new RuntimeException("No such type: " + name);
            e.fillInStackTrace();
            e.printStackTrace();
            throw e;
        }
        return ret;
    }

    public void addDecorator(MetaDecorator decorator) {
        this.decorators.put(decorator.getName(), decorator);
    }

    public void addDecorators(List<MetaDecorator> someDecorators) {
        for (int i = 0; i < someDecorators.size(); ++i) {
            this.addDecorator(someDecorators.get(i));
        }
    }

    public MetaDecorator getDecorator(String name) {
        return this.decorators.get(name);
    }

    public MetaDecorator createDecorator(String name, String rule) {
        MetaDecorator blueprint = this.getDecorator(name);
        if (blueprint == null) {
            throw new RuntimeException("No such decorator: " + name);
        }
        MetaDecorator ret = (MetaDecorator)blueprint.clone();
        ret.setRule(rule);
        return ret;
    }

    public void addFilter(MetaFilter filter) {
        this.filters.put(filter.getName(), filter);
    }

    public void addFilters(List<MetaFilter> aFilters) {
        for (int i = 0; i < aFilters.size(); ++i) {
            this.addFilter(aFilters.get(i));
        }
    }

    public MetaFilter getFilter(String name) {
        return this.filters.get(name);
    }

    public MetaFilter createFilter(String name, String fieldName) {
        MetaFilter blueprint = this.getFilter(name);
        if (blueprint == null) {
            throw new RuntimeException("No such filter: " + name);
        }
        MetaFilter ret = (MetaFilter)blueprint.clone();
        ret.setFieldName(fieldName);
        return ret;
    }

    public void addValidator(MetaValidator validator) {
        this.validators.put(validator.getName(), validator);
    }

    public void addValidators(List<MetaValidator> aValidators) {
        for (MetaValidator validator : aValidators) {
            this.addValidator(validator);
        }
    }

    public MetaValidator getValidator(String name) {
        MetaValidator result = this.validators.get(name);
        if (result == null) {
            throw new RuntimeException("No such validator: " + name);
        }
        return result;
    }

    public static boolean hasLanguageCopyMethods(MetaDocument doc) {
        if (!GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported()) {
            return false;
        }
        return doc.isMultilingual();
    }

    private static GenerationOptions createDefaultGenerationOptions() {
        GenerationOptions ret = new GenerationOptions();
        ret.set("rmi", "false");
        ret.set("inmemory", "false");
        return ret;
    }

    public GenerationOptions getOptions() {
        return this.options;
    }

    public void setOptions(GenerationOptions options) {
        this.options = options;
    }
}

