/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedArtefact;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.TypeOfClass;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.view.action.ModuleActionsGenerator;

public class BasicServiceUtilGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaModule> modules) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        entries.add(new FileEntry(this.generateParsingUtilService(modules)));
        entries.add(new FileEntry(this.generateEnumModules(modules)));
        entries.add(new FileEntry(this.generateEnumDocuments(modules)));
        entries.add(new FileEntry(this.generateRestResourceForImages()));
        return entries;
    }

    private GeneratedClass generateEnumModules(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateEnumModules");
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".util");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.setType(TypeOfClass.ENUM);
        clazz.setName("ModuleName");
        this.startClassBody();
        for (MetaModule module : modules) {
            this.appendString("SERVICE_" + module.getName().toUpperCase() + "(\"" + module.getName() + "\"),");
        }
        this.appendStatement(new String[0]);
        BasicServiceUtilGenerator.emptyline();
        this.appendStatement("private String name");
        BasicServiceUtilGenerator.emptyline();
        this.appendString("ModuleName (String aName) {");
        this.increaseIdent();
        this.appendStatement("name = aName");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("public static ModuleName byValue (final String value) {");
        this.increaseIdent();
        this.appendString("if (StringUtils.isEmpty(value))");
        this.increaseIdent();
        this.appendStatement("throw new IllegalArgumentException(\"Value is not valid\")");
        this.decreaseIdent();
        this.appendString("for (ModuleName moduleName: ModuleName.values()) {");
        this.increaseIdent();
        this.appendString("if (moduleName.name.equals(value)) {");
        this.increaseIdent();
        this.appendStatement("return moduleName");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("throw new IllegalArgumentException(\"No such value in DataType\")");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateEnumDocuments(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateEnumDocuments");
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".util");
        clazz.addImport("net.anotheria.util.StringUtils");
        clazz.setType(TypeOfClass.ENUM);
        clazz.setName("DocumentName");
        this.startClassBody();
        for (MetaModule module : modules) {
            for (MetaDocument doc : module.getDocuments()) {
                this.appendString("DOCUMENT_" + module.getName().toUpperCase() + "_" + doc.getName().toUpperCase() + "(\"" + module.getName() + "_" + doc.getName() + "\"),");
            }
        }
        this.appendStatement(new String[0]);
        BasicServiceUtilGenerator.emptyline();
        this.appendStatement("private String name");
        BasicServiceUtilGenerator.emptyline();
        this.appendString("DocumentName (String aName) {");
        this.increaseIdent();
        this.appendStatement("name = aName");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("public static DocumentName byValue (final String value) {");
        this.increaseIdent();
        this.appendString("if (StringUtils.isEmpty(value))");
        this.increaseIdent();
        this.appendStatement("throw new IllegalArgumentException(\"Value is not valid\")");
        this.decreaseIdent();
        this.appendString("for (DocumentName documentName: DocumentName.values()) {");
        this.increaseIdent();
        this.appendString("if (documentName.name.equals(value)) {");
        this.increaseIdent();
        this.appendStatement("return documentName");
        this.closeBlockNEW();
        this.closeBlockNEW();
        this.appendStatement("throw new IllegalArgumentException(\"No such value in DataType\")");
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedClass generateParsingUtilService(List<MetaModule> modules) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateParsingUtilService");
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".util");
        clazz.addImport("net.anotheria.anosite.gen.shared.service.BasicService");
        clazz.addImport("net.anotheria.asg.exception.ASGRuntimeException");
        clazz.addImport("net.anotheria.util.queue.IQueueWorker");
        clazz.addImport("net.anotheria.util.queue.QueuedProcessor");
        clazz.addImport("org.codehaus.jettison.json.JSONObject");
        clazz.addImport("org.codehaus.jettison.json.JSONArray");
        clazz.addImport("org.codehaus.jettison.json.JSONException");
        clazz.setClazzComment("Util service for processing transferred documents.");
        clazz.setName("ParserUtilService");
        clazz.setParent("BasicService");
        this.startClassBody();
        this.appendComment("Constructed instance.");
        this.appendStatement("private static final ParserUtilService instance = new ParserUtilService()");
        this.appendComment("Process parse documents in own worker. {@link QueuedProcessor} instance.");
        this.appendStatement("private final QueuedProcessor<JSONArray> documentExecutor");
        BasicServiceUtilGenerator.emptyline();
        this.appendComment("Default constructor.");
        this.appendString("private ParserUtilService() {");
        this.increaseIdent();
        this.appendStatement("documentExecutor = new QueuedProcessor<>(\"DocumentTransferExecutorQueuedProcessor\", new DocumentExecutor(), 10, log)");
        this.appendStatement("documentExecutor.start()");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendComment("Get configured {@link ParserUtilService} instance.\n\n@return {@link ParserUtilService} instance");
        this.appendString("public static ParserUtilService getInstance() {");
        this.increaseIdent();
        this.appendStatement("return instance");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendComment("Add transferred objects to processing queue.\n\n@param data {@link JSONArray} of documents\n@throws Exception if any errors occurs");
        this.appendString("public void addToQueueParsingDocuments(final JSONArray data) throws Exception {");
        this.increaseIdent();
        this.appendStatement("documentExecutor.addToQueue(data)");
        this.appendStatement("log.info(\"Document added to work. Total document size:\" + data.length())");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("private void executeParsingDocuments (final JSONArray data) throws ASGRuntimeException, JSONException {");
        this.increaseIdent();
        this.appendString("for (int i = 0; i < data.length(); i++) {");
        this.increaseIdent();
        this.appendStatement("executeParsingDocument(data.getJSONObject(i))");
        this.closeBlockNEW();
        this.appendStatement("log.info(\"Finished parsing documents. Total document size:\" + data.length())");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("private void executeParsingDocument(final JSONObject data) throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendStatement("final ModuleName moduleName");
        this.appendStatement("final DocumentName documentName");
        this.openTry();
        this.appendStatement("moduleName = ModuleName.byValue(data.getString(\"service\"))");
        this.appendStatement("documentName = DocumentName.byValue(data.getString(\"document\"))");
        this.appendCatch("JSONException");
        this.appendStatement("throw new ASGRuntimeException(\"Occurred problems with getting document metadata from json:\", e)");
        this.closeBlockNEW();
        this.appendStatement("executeParsingInServiceByName(moduleName, documentName, data)");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("protected void executeParsingInServiceByName(final ModuleName moduleName, final DocumentName documentName, final JSONObject dataObject) throws ASGRuntimeException {");
        this.increaseIdent();
        this.appendString("switch (moduleName) {");
        this.increaseIdent();
        for (MetaModule module : modules) {
            this.appendString("case SERVICE_" + module.getName().toUpperCase() + ":");
            this.increaseIdent();
            this.appendStatement(ModuleActionsGenerator.getServiceGetterCall(module) + ".executeParsingForDocument(documentName, dataObject)");
            this.appendStatement("break");
            this.decreaseIdent();
        }
        this.appendString("default:");
        this.increaseIdent();
        this.appendStatement("log.error(\"There is no needed module\")");
        this.appendStatement("throw new ASGRuntimeException(\"No such module\")");
        this.decreaseIdent();
        this.closeBlockNEW();
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.appendString("private class DocumentExecutor implements IQueueWorker<JSONArray> {");
        this.increaseIdent();
        this.appendString("@Override");
        this.appendString("public void doWork(JSONArray jsonArray) throws Exception {");
        this.increaseIdent();
        this.appendStatement("executeParsingDocuments(jsonArray)");
        this.closeBlockNEW();
        this.closeBlockNEW();
        return clazz;
    }

    private GeneratedArtefact generateRestResourceForImages() {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        this.appendGenerationPoint("generateUploadImageResource");
        clazz.setPackageName(GeneratorDataRegistry.getInstance().getContext().getPackageName(MetaModule.SHARED) + ".rest");
        clazz.addImport("org.glassfish.jersey.media.multipart.FormDataContentDisposition");
        clazz.addImport("org.glassfish.jersey.media.multipart.FormDataParam");
        clazz.addImport("jakarta.ws.rs.Consumes");
        clazz.addImport("jakarta.ws.rs.Produces");
        clazz.addImport("jakarta.ws.rs.POST");
        clazz.addImport("jakarta.ws.rs.Path");
        clazz.addImport("jakarta.ws.rs.core.Context");
        clazz.addImport("jakarta.ws.rs.core.MediaType");
        clazz.addImport("jakarta.ws.rs.core.Response");
        clazz.addImport("jakarta.ws.rs.core.UriInfo");
        clazz.addImport("java.io.File");
        clazz.addImport("java.io.FileOutputStream");
        clazz.addImport("java.io.IOException");
        clazz.addImport("java.io.InputStream");
        clazz.addImport("java.io.OutputStream");
        clazz.addImport("org.slf4j.Logger");
        clazz.addImport("org.slf4j.LoggerFactory");
        clazz.addImport("net.anotheria.webutils.filehandling.FileStorageConfig");
        clazz.addImport("net.anotheria.util.log.LogMessageUtil");
        clazz.addAnnotation("@Path(\"/asgimage\")");
        clazz.setName("UploadImageResource");
        this.startClassBody();
        this.appendStatement("private static final Logger LOGGER = LoggerFactory.getLogger(UploadImageResource.class)");
        BasicServiceUtilGenerator.emptyline();
        this.appendStatement("private static final FileStorageConfig CONFIG = FileStorageConfig.getInstance()");
        BasicServiceUtilGenerator.emptyline();
        this.appendString("@Context");
        this.appendStatement("private UriInfo context");
        BasicServiceUtilGenerator.emptyline();
        this.appendString("public UploadImageResource(){}");
        BasicServiceUtilGenerator.emptyline();
        this.appendString("@POST");
        this.appendString("@Path(\"/upload\")");
        this.appendString("@Consumes(MediaType.MULTIPART_FORM_DATA)");
        this.appendString("@Produces(MediaType.APPLICATION_JSON)");
        this.openFun("public Response uploadFile( @FormDataParam(\"file\") InputStream uploadedInputStream, @FormDataParam(\"file\") FormDataContentDisposition fileDetail)");
        this.appendString("if (uploadedInputStream == null || fileDetail == null)");
        this.increaseIdent();
        this.appendStatement("return Response.status(400).entity(\"Invalid form data\").build()");
        this.decreaseIdent();
        BasicServiceUtilGenerator.emptyline();
        this.appendStatement("String uploadedFileLocation = CONFIG.getDirectory() + File.separator + fileDetail.getFileName()");
        this.openTry();
        this.appendStatement("writeToFile(uploadedInputStream, uploadedFileLocation)");
        this.appendCatch("IOException");
        this.appendStatement("String failMsg = LogMessageUtil.failMsg(e)");
        this.appendStatement("LOGGER.error(failMsg)");
        this.appendStatement("return Response.status(500).entity(failMsg).build()");
        this.closeBlockNEW();
        this.appendStatement("return Response.status(201).build()");
        this.closeBlockNEW();
        BasicServiceUtilGenerator.emptyline();
        this.openFun("private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws IOException");
        this.appendStatement("OutputStream out = new FileOutputStream(uploadedFileLocation)");
        this.appendStatement("int read = 0");
        this.appendStatement("byte[] bytes = new byte[4096];");
        this.appendString("while ((read = uploadedInputStream.read(bytes)) != -1) {");
        this.increaseIdent();
        this.appendStatement("out.write(bytes, 0, read)");
        this.closeBlockNEW();
        this.appendStatement("out.flush()");
        this.appendStatement("out.close()");
        this.closeBlockNEW();
        return clazz;
    }
}

