/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.asg.generator.apputil.LanguageUtilsGenerator;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.util.StringUtils;

public class CallContextGenerator
extends AbstractGenerator
implements IGenerator {
    @Override
    public List<FileEntry> generate(IGenerateable g) {
        ArrayList<FileEntry> ret = new ArrayList<FileEntry>();
        ret.add(this.generateCallContextFactory());
        ret.add(this.generateCallContext());
        return ret;
    }

    private FileEntry generateCallContext() {
        Context context = GeneratorDataRegistry.getInstance().getContext();
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.addImport("net.anotheria.anodoc.util.context.CallContext");
        clazz.addImport("java.io.Serializable");
        clazz.addImport("java.util.List");
        clazz.setName(CallContextGenerator.getCallContextName(context));
        clazz.setParent("CallContext");
        clazz.addInterface("Serializable");
        this.startClassBody();
        this.appendString("public String getDefaultLanguage() {");
        this.increaseIdent();
        this.appendStatement("return " + this.quote(context.getDefaultLanguage()));
        this.append(this.closeBlock());
        this.appendString("public List<String> getSupportedLanguages() {");
        this.increaseIdent();
        if (context.areLanguagesSupported()) {
            clazz.addImport(context.getServicePackageName(MetaModule.SHARED) + "." + LanguageUtilsGenerator.getCopierClassName(context));
            this.appendStatement("return " + LanguageUtilsGenerator.getCopierClassName(context) + ".getSupportedLanguages()");
        } else {
            clazz.addImport("java.util.ArrayList");
            this.appendStatement("return new ArrayList<String>()");
        }
        this.append(this.closeBlock());
        return new FileEntry(clazz);
    }

    private FileEntry generateCallContextFactory() {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(this.getPackageName());
        clazz.addImport("net.anotheria.anodoc.util.context.CallContextFactory");
        clazz.addImport("net.anotheria.anodoc.util.context.CallContext");
        clazz.setName(CallContextGenerator.getFactoryName(GeneratorDataRegistry.getInstance().getContext()));
        clazz.addInterface("CallContextFactory");
        this.startClassBody();
        this.appendString("public CallContext createContext(){");
        this.increaseIdent();
        this.appendStatement("return new " + this.getPreName() + "CallContext()");
        this.append(this.closeBlock());
        return new FileEntry(clazz);
    }

    private static String getPreName(Context context) {
        return StringUtils.capitalize((String)context.getApplicationName());
    }

    private String getPreName() {
        return CallContextGenerator.getPreName(GeneratorDataRegistry.getInstance().getContext());
    }

    private String getPackageName() {
        return CallContextGenerator.getPackageName(GeneratorDataRegistry.getInstance().getContext());
    }

    private static String getPackageName(Context context) {
        return context.getTopPackageName() + ".util";
    }

    public static final String getFullFactoryName(Context c) {
        return CallContextGenerator.getPackageName(c) + "." + CallContextGenerator.getFactoryName(c);
    }

    public static String getFactoryName(Context c) {
        return CallContextGenerator.getPreName(c) + "CallContextFactory";
    }

    public static String getCallContextName(Context c) {
        return CallContextGenerator.getPreName(c) + "CallContext";
    }
}

