/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.util.StringUtils;

public class LanguageUtilsGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaModule> modules, Context context) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        if (context.areLanguagesSupported()) {
            entries.add(this.generateLanguageCopy(modules, context));
        }
        return entries;
    }

    public static String getCopierClassName(Context context) {
        return StringUtils.capitalize((String)context.getApplicationName()) + "LanguageUtils";
    }

    private FileEntry generateLanguageCopy(List<MetaModule> modules, Context context) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(context.getServicePackageName(MetaModule.SHARED));
        HashSet<MetaModule> modulesSet = new HashSet<MetaModule>();
        for (MetaModule m : modules) {
            for (MetaDocument doc : m.getDocuments()) {
                if (!GeneratorDataRegistry.hasLanguageCopyMethods(doc)) continue;
                modulesSet.add(m);
            }
        }
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.Arrays");
        LanguageUtilsGenerator.emptyline();
        for (MetaModule m : modulesSet) {
            clazz.addImport(ServiceGenerator.getFactoryImport(m));
        }
        clazz.setName(LanguageUtilsGenerator.getCopierClassName(context));
        this.startClassBody();
        this.appendString("private static final List<String> supportedLanguages = Arrays.asList(new String[]{");
        this.increaseIdent();
        List<String> languages = context.getLanguages();
        for (String l : languages) {
            this.appendString(this.quote(l) + ",");
        }
        this.decreaseIdent();
        this.appendString("});");
        LanguageUtilsGenerator.emptyline();
        this.appendString("public static List<String> getSupportedLanguages(){");
        this.increaseIdent();
        this.appendStatement("return supportedLanguages");
        this.append(this.closeBlock());
        LanguageUtilsGenerator.emptyline();
        this.appendString("public static void copyAttributesFromLanguage2Language(String sourceLang, String targetLanguage){");
        this.increaseIdent();
        this.append(this.closeBlock());
        LanguageUtilsGenerator.emptyline();
        this.appendString("public static void main(String[] a) throws Exception{");
        this.increaseIdent();
        this.appendStatement("String sourceLang, targetLang");
        this.appendString("if (a.length!=2)");
        this.appendIncreasedStatement("throw new RuntimeException(" + this.quote("Wrong number of arguments, please use " + LanguageUtilsGenerator.getCopierClassName(context) + " sourcelanguage targetlanguage") + ")");
        this.appendStatement("sourceLang = a[0].toUpperCase()");
        this.appendStatement("checkParameter(sourceLang)");
        this.appendStatement("targetLang = a[1].toUpperCase()");
        this.appendStatement("checkParameter(targetLang)");
        LanguageUtilsGenerator.emptyline();
        this.appendStatement("copy(sourceLang, targetLang)");
        this.append(this.closeBlock());
        LanguageUtilsGenerator.emptyline();
        this.appendString("private static void checkParameter(String lang){");
        this.increaseIdent();
        this.appendString("if (supportedLanguages.indexOf(lang)==-1)");
        this.appendIncreasedStatement("throw new RuntimeException(" + this.quote("Language ") + "+lang+" + this.quote("not supported") + ")");
        this.append(this.closeBlock());
        LanguageUtilsGenerator.emptyline();
        this.appendString("private static void copy(String sourceLanguage, String targetLanguage) throws Exception {");
        this.increaseIdent();
        this.appendString("//initialize and copy");
        for (MetaModule m : modulesSet) {
            this.appendStatement("System.out.println(\"Working on " + ServiceGenerator.getServiceName(m) + "\")");
            this.appendStatement(ServiceGenerator.getFactoryName(m) + ".create" + ServiceGenerator.getServiceName(m) + "().copyMultilingualAttributesInAllObjects(sourceLanguage, targetLanguage)");
        }
        LanguageUtilsGenerator.emptyline();
        this.append(this.closeBlock());
        return new FileEntry(clazz);
    }
}

