/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedXMLFile;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.IGenerator;
import net.anotheria.util.StringUtils;

public class Log4JConfigurationGenerator
extends AbstractGenerator
implements IGenerator {
    private static final String[] categories = new String[]{"debug", "info", "warn", "error", "fatal"};
    public static final String GENERATED_PACKAGE = "net.anotheria.anosite.gen";

    @Override
    public List<FileEntry> generate(IGenerateable g) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        GeneratedXMLFile log4Config = this.generateContent();
        log4Config.setPath("/etc/appdata");
        FileEntry entry = new FileEntry(log4Config);
        entry.setType(".xml");
        files.add(entry);
        return files;
    }

    private GeneratedXMLFile generateContent() {
        GeneratedXMLFile artefact = new GeneratedXMLFile("log4j", "UTF-8");
        this.startNewJob(artefact);
        this.appendString("<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">");
        this.appendString("<log4j:configuration xmlns:log4j='http://jakarta.apache.org/log4j/'>");
        this.increaseIdent();
        Log4JConfigurationGenerator.emptyline();
        this.appendString("<!-- File Appenders for generated code -->");
        Log4JConfigurationGenerator.emptyline();
        for (String cat : categories) {
            this.appendString("<!-- File Appender for ", cat, " and higher -->");
            this.appendString("<appender name=", this.quote(StringUtils.capitalize((String)cat) + "GenAppender"), " class=" + this.quote("org.apache.log4j.RollingFileAppender"), ">");
            this.increaseIdent();
            this.appendString("<param name=", this.quote("File"), " value=", this.quote("logs/" + GeneratorDataRegistry.getInstance().getContext().getApplicationName() + "-gen-" + cat + ".log"), " />");
            this.appendString("<param name=", this.quote("Threshold"), " value=", this.quote(cat.toUpperCase()), " />");
            this.appendString("<param name=", this.quote("MaxFileSize"), " value=", this.quote("100MB"), " />  ");
            this.appendString("<param name=", this.quote("MaxBackupIndex"), " value=", this.quote(5), " />");
            this.appendString("<layout class=", this.quote("org.apache.log4j.PatternLayout"), ">");
            this.increaseIdent();
            this.appendString("<param name=", this.quote("ConversionPattern"), " value=", this.quote("%r %d{ISO8601} %-5p %c - %m%n"), "/>");
            this.decreaseIdent();
            this.appendString("</layout>");
            this.decreaseIdent();
            this.appendString("</appender>");
        }
        Log4JConfigurationGenerator.emptyline();
        this.appendString("<!-- File Appenders for written code -->");
        Log4JConfigurationGenerator.emptyline();
        for (String cat : categories) {
            this.appendString("<!-- File Appender for ", cat, " and higher -->");
            this.appendString("<appender name=", this.quote(StringUtils.capitalize((String)cat) + "Appender"), " class=" + this.quote("org.apache.log4j.RollingFileAppender"), ">");
            this.increaseIdent();
            this.appendString("<param name=", this.quote("File"), " value=", this.quote("logs/" + GeneratorDataRegistry.getInstance().getContext().getApplicationName() + "-" + cat + ".log"), " />");
            this.appendString("<param name=", this.quote("Threshold"), " value=", this.quote(cat.toUpperCase()), " />");
            this.appendString("<param name=", this.quote("MaxFileSize"), " value=", this.quote("100MB"), " />  ");
            this.appendString("<param name=", this.quote("MaxBackupIndex"), " value=", this.quote(5), " />");
            this.appendString("<layout class=", this.quote("org.apache.log4j.PatternLayout"), ">");
            this.increaseIdent();
            this.appendString("<param name=", this.quote("ConversionPattern"), " value=", this.quote("%r %d{ISO8601} %-5p %c - %m%n"), "/>");
            this.decreaseIdent();
            this.appendString("</layout>");
            this.decreaseIdent();
            this.appendString("</appender>");
        }
        Log4JConfigurationGenerator.emptyline();
        this.appendString("<!-- Console appender -->");
        this.appendString("<appender name=" + this.quote("ConsoleAppender"), " class=", this.quote("org.apache.log4j.ConsoleAppender"), ">");
        this.increaseIdent();
        this.appendString("<param name=" + this.quote("Threshold"), " value=" + this.quote("WARN"), " />");
        this.appendString("<layout class=" + this.quote("org.apache.log4j.PatternLayout"), ">");
        this.increaseIdent();
        this.appendString("<param name=" + this.quote("ConversionPattern"), " value=", this.quote("%r %d{ISO8601} %-5p %c - %m%n"), "/>");
        this.decreaseIdent();
        this.appendString("</layout>");
        this.decreaseIdent();
        this.appendString("</appender>");
        Log4JConfigurationGenerator.emptyline();
        this.appendString("<logger name=", this.quote(GeneratorDataRegistry.getInstance().getContext().getTopPackageName()), " additivity=", this.quote("false"), ">");
        this.increaseIdent();
        this.appendString("<level value=", this.quote("INFO"), "/>");
        for (String cat : categories) {
            this.appendString("<appender-ref ref=", this.quote(StringUtils.capitalize((String)cat) + "GenAppender"), "/>");
        }
        this.decreaseIdent();
        this.appendString("</logger>");
        Log4JConfigurationGenerator.emptyline();
        this.appendString("<logger name=", this.quote("net.anotheria." + GeneratorDataRegistry.getInstance().getContext().getApplicationName().toLowerCase()), " additivity=", this.quote("false"), ">");
        this.increaseIdent();
        this.appendString("<level value=", this.quote("INFO"), "/>");
        for (String cat : categories) {
            this.appendString("<appender-ref ref=", this.quote(StringUtils.capitalize((String)cat) + "Appender"), "/>");
        }
        this.decreaseIdent();
        this.appendString("</logger>");
        Log4JConfigurationGenerator.emptyline();
        this.decreaseIdent();
        this.appendString("</log4j:configuration>");
        return artefact;
    }
}

