/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.ConfiguratorGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.util.StringUtils;

public class XMLExporterGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaModule> modules) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        entries.add(new FileEntry(this.generateExporter(modules)));
        return entries;
    }

    public static String getExporterClassName(Context context) {
        return StringUtils.capitalize((String)context.getApplicationName()) + "XMLExporter";
    }

    /*
     * WARNING - void declaration
     */
    private GeneratedClass generateExporter(List<MetaModule> modules) {
        String langParam;
        Context context = GeneratorDataRegistry.getInstance().getContext();
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(context.getServicePackageName(MetaModule.SHARED));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.io.File");
        clazz.addImport("java.io.FileOutputStream");
        clazz.addImport("java.io.OutputStream");
        clazz.addImport("java.io.IOException");
        clazz.addImport("java.io.OutputStreamWriter");
        clazz.addImport("java.nio.charset.Charset");
        clazz.addImport("java.util.concurrent.atomic.AtomicLong");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLTree");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.util.xml.XMLWriter");
        clazz.addImport("net.anotheria.util.Date");
        clazz.addImport("net.anotheria.util.IOUtils");
        clazz.addImport(StringUtils.class);
        clazz.addImport(ASGRuntimeException.class);
        for (MetaModule metaModule : modules) {
            clazz.addImport(ServiceGenerator.getFactoryImport(metaModule));
        }
        clazz.setName(XMLExporterGenerator.getExporterClassName(context));
        this.startClassBody();
        this.appendStatement("private static AtomicLong exp = new AtomicLong()");
        this.appendStatement("private static String[] LANGUAGES = null");
        String LANGUAGES = GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() ? "LANGUAGES" : "";
        this.appendString("static {");
        this.increaseIdent();
        this.appendStatement(ConfiguratorGenerator.getConfiguratorClassName() + ".configure()");
        this.appendStatement("String expLanguages = System.getProperty(" + this.quote("anosite.export.languages") + ")");
        this.appendString("if (expLanguages!=null && expLanguages.length()>0)");
        this.appendIncreasedStatement("LANGUAGES = StringUtils.tokenize(expLanguages, ',')");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendComment("Create an XML Document (ano-util) with data from all modules.");
        this.appendString("public static XMLTree createCompleteXMLExport() throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("ArrayList<XMLNode> nodes = new ArrayList<XMLNode>()");
        for (MetaModule m : modules) {
            langParam = GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && m.isContainsAnyMultilingualDocs() ? LANGUAGES : "";
            this.appendStatement("nodes.add(" + ServiceGenerator.getFactoryName(m) + ".create" + ServiceGenerator.getServiceName(m) + "().exportToXML(" + langParam + "))");
        }
        this.appendStatement("return createExport(nodes)");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendComment("Write XML data from all modules into given stream.");
        this.appendString("public static void writeCompleteXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("new XMLWriter().write(createCompleteXMLExport(), target).close()");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendComment("Write XML data from all modules into given file.");
        this.appendString("public static void writeCompleteXMLExportToFile(File target) throws IOException, ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("writeToFile(createCompleteXMLExport(), target)");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        for (MetaModule m : modules) {
            this.appendComment("Create an XML Document (jdom) from " + m.getName() + " data for export.");
            this.appendString("public static XMLTree create" + m.getName() + "XMLExport() throws ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1)");
            langParam = GeneratorDataRegistry.getInstance().getContext().areLanguagesSupported() && m.isContainsAnyMultilingualDocs() ? LANGUAGES : "";
            this.appendStatement("nodes.add(" + ServiceGenerator.getFactoryName(m) + ".create" + ServiceGenerator.getServiceName(m) + "().exportToXML(" + langParam + "))");
            this.appendStatement("return createExport(nodes)");
            this.append(this.closeBlock());
            XMLExporterGenerator.emptyline();
            this.appendComment("Write " + m.getName() + " as XML into given stream.");
            this.appendString("public static void write" + m.getName() + "XMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("new XMLWriter().write(create" + m.getName() + "XMLExport(), target)");
            this.append(this.closeBlock());
            XMLExporterGenerator.emptyline();
            this.appendComment("Write " + m.getName() + " as XML into given file.");
            this.appendString("public static void write" + m.getName() + "XMLExportToFile(File target) throws IOException, ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("writeToFile(create" + m.getName() + "XMLExport(), target)");
            this.append(this.closeBlock());
            XMLExporterGenerator.emptyline();
        }
        this.appendString("private static void writeToFile(XMLTree tree, File target) throws IOException{");
        this.increaseIdent();
        this.appendStatement("FileOutputStream fOut = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("fOut = new FileOutputStream(target)");
        this.appendStatement("XMLWriter writer = new XMLWriter()");
        this.appendStatement("OutputStreamWriter oWriter = writer.write(tree, fOut)");
        this.appendStatement("oWriter.close()");
        this.decreaseIdent();
        this.appendStatement("}catch(IOException e){");
        this.increaseIdent();
        this.appendString("if (fOut!=null){");
        this.increaseIdent();
        this.appendString("try{");
        this.appendIncreasedStatement("fOut.close()");
        this.appendString("}catch(IOException ignored){}");
        this.append(this.closeBlock());
        this.appendStatement("throw e");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendString("private static XMLTree createExport(List<XMLNode> nodes){");
        this.increaseIdent();
        this.appendStatement("XMLTree tree = new XMLTree()");
        this.appendStatement("tree.setEncoding(" + this.quote(GeneratorDataRegistry.getInstance().getContext().getEncoding()) + ")");
        this.appendStatement("XMLNode root = new XMLNode(" + this.quote("export") + ")");
        this.appendStatement("root.addAttribute(new XMLAttribute(" + this.quote("timestamp") + ", \"\"+System.currentTimeMillis()))");
        this.appendStatement("root.addAttribute(new XMLAttribute(" + this.quote("date") + ", Date.currentDate().toString()))");
        this.appendStatement("tree.setRoot(root)");
        this.appendStatement("root.setChildren(nodes)");
        this.appendStatement("return tree");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendString("public static void main(String[] a) throws IOException,ASGRuntimeException{");
        this.increaseIdent();
        this.appendString("if (a.length==0)");
        this.appendIncreasedStatement("interactiveMode(a)");
        this.appendString("else");
        this.appendIncreasedStatement("automaticMode(a)");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendString("public static void interactiveMode(String a[]) throws IOException,ASGRuntimeException{");
        this.increaseIdent();
        this.appendString("while(true){");
        this.increaseIdent();
        this.appendStatement("System.out.println(" + this.quote("Please make your choice:") + ")");
        this.appendStatement("System.out.println(" + this.quote("0 - Quit") + ")");
        this.appendStatement("System.out.println(" + this.quote("1 - Complete export") + ")");
        int n = 2;
        for (MetaModule m : modules) {
            void var5_9;
            this.appendStatement("System.out.println(" + this.quote((int)var5_9 + " - Export " + m.getName() + " [" + m.getStorageType() + "]") + ")");
            ++var5_9;
        }
        this.appendStatement("String myInput = IOUtils.readlineFromStdIn()");
        this.appendStatement("XMLTree tree = createExportForInput(myInput)");
        this.appendString("if (tree==null)");
        this.appendIncreasedStatement("System.exit(0)");
        this.appendStatement("FileOutputStream fOut = new FileOutputStream(new File(\"export-\"+exp.incrementAndGet()+\".xml\"))");
        this.appendStatement("OutputStreamWriter writer = new OutputStreamWriter(fOut, Charset.forName(" + this.quote(GeneratorDataRegistry.getInstance().getContext().getEncoding()) + "))");
        this.appendStatement("tree.write(writer)");
        this.appendStatement("writer.flush()");
        this.appendStatement("writer.close()");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendString("public static void automaticMode(String a[]) throws IOException,ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("new " + XMLExporterGenerator.getExporterClassName(context) + "().writeCompleteXMLExportToFile(new File(" + this.quote(context.getApplicationName() + "_export.xml") + "))");
        this.append(this.closeBlock());
        XMLExporterGenerator.emptyline();
        this.appendString("public static final XMLTree createExportForInput(String input) throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendString("if (" + this.quote("0") + ".equals(input))");
        this.appendIncreasedStatement("return null");
        this.appendString("if (" + this.quote("1") + ".equals(input))");
        this.appendIncreasedStatement("return createCompleteXMLExport()");
        int n2 = 2;
        for (MetaModule m : modules) {
            void var5_11;
            this.appendString("if (" + this.quote("" + (int)var5_11) + ".equals(input))");
            this.appendIncreasedStatement("return create" + m.getName() + "XMLExport()");
            ++var5_11;
        }
        this.appendStatement("throw new RuntimeException(" + this.quote("Unrecognized input: ") + " +input)");
        this.append(this.closeBlock());
        return clazz;
    }
}

