/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.apputil;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.asg.generator.AbstractGenerator;
import net.anotheria.asg.generator.ConfiguratorGenerator;
import net.anotheria.asg.generator.Context;
import net.anotheria.asg.generator.FileEntry;
import net.anotheria.asg.generator.GeneratedClass;
import net.anotheria.asg.generator.GeneratorDataRegistry;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.model.ServiceGenerator;
import net.anotheria.util.StringUtils;

public class XMLImporterGenerator
extends AbstractGenerator {
    public List<FileEntry> generate(List<MetaModule> modules, Context context) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        entries.add(this.generateImporter(modules, context));
        return entries;
    }

    public static String getImporterClassName(Context context) {
        return StringUtils.capitalize((String)context.getApplicationName()) + "XMLImporter";
    }

    private void generateDocumentParser() {
        this.appendString("public static Document parseDocument(String content) throws JDOMException, IOException{");
        this.increaseIdent();
        this.appendStatement("SAXBuilder reader = new SAXBuilder();");
        this.appendStatement("reader.setValidation(false)");
        this.appendStatement("Document doc = reader.build(new StringReader(content))");
        this.appendStatement("return doc");
        this.append(this.closeBlock());
    }

    private FileEntry generateImporter(List<MetaModule> modules, Context context) {
        GeneratedClass clazz = new GeneratedClass();
        this.startNewJob(clazz);
        clazz.setPackageName(context.getServicePackageName(MetaModule.SHARED));
        clazz.addImport("java.util.List");
        clazz.addImport("java.util.ArrayList");
        clazz.addImport("java.io.File");
        clazz.addImport("java.io.FileOutputStream");
        clazz.addImport("java.io.OutputStream");
        clazz.addImport("java.io.IOException");
        clazz.addImport("java.io.OutputStreamWriter");
        clazz.addImport("org.jdom2.Element");
        clazz.addImport("org.jdom2.Attribute");
        clazz.addImport("org.jdom2.Document");
        clazz.addImport("java.io.StringReader");
        clazz.addImport("org.jdom2.JDOMException");
        clazz.addImport("org.jdom2.input.SAXBuilder");
        clazz.addImport("net.anotheria.util.xml.XMLNode");
        clazz.addImport("net.anotheria.util.xml.XMLTree");
        clazz.addImport("net.anotheria.util.xml.XMLAttribute");
        clazz.addImport("net.anotheria.util.xml.XMLWriter");
        clazz.addImport("net.anotheria.util.Date");
        clazz.addImport(ASGRuntimeException.class.getName());
        XMLImporterGenerator.emptyline();
        for (MetaModule m : modules) {
            clazz.addImport(ServiceGenerator.getFactoryImport(m));
        }
        XMLImporterGenerator.emptyline();
        clazz.setName(XMLImporterGenerator.getImporterClassName(context));
        this.startClassBody();
        this.appendString("public " + XMLImporterGenerator.getImporterClassName(context) + "(){");
        this.increaseIdent();
        this.appendStatement(ConfiguratorGenerator.getConfiguratorClassName() + ".configure()");
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        this.generateDocumentParser();
        XMLImporterGenerator.emptyline();
        this.appendComment("Create an XML Document (ano-util) with data from all modules.");
        this.appendString("public XMLTree createCompleteXMLExport() throws ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("ArrayList<XMLNode> nodes = new ArrayList<XMLNode>()");
        for (MetaModule m : modules) {
            this.appendStatement("nodes.add(" + ServiceGenerator.getFactoryName(m) + ".create" + ServiceGenerator.getServiceName(m) + "().exportToXML())");
        }
        this.appendStatement("return createExport(nodes)");
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        this.appendComment("Write XML data from all modules into given stream.");
        this.appendString("public void writeCompleteXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("new XMLWriter().write(createCompleteXMLExport(), target)");
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        this.appendComment("Write XML data from all modules into given file.");
        this.appendString("public void writeCompleteXMLExportToFile(File target) throws IOException, ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("writeToFile(createCompleteXMLExport(), target)");
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        for (MetaModule m : modules) {
            this.appendComment("Create an XML Document (jdom) from " + m.getName() + " data for export.");
            this.appendString("public XMLTree create" + m.getName() + "XMLExport() throws ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1)");
            this.appendStatement("nodes.add(" + ServiceGenerator.getFactoryName(m) + ".create" + ServiceGenerator.getServiceName(m) + "().exportToXML())");
            this.appendStatement("return createExport(nodes)");
            this.append(this.closeBlock());
            XMLImporterGenerator.emptyline();
            this.appendComment("Write " + m.getName() + " as XML into given stream.");
            this.appendString("public void write" + m.getName() + "XMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("new XMLWriter().write(create" + m.getName() + "XMLExport(), target)");
            this.append(this.closeBlock());
            XMLImporterGenerator.emptyline();
            this.appendComment("Write " + m.getName() + " as XML into given file.");
            this.appendString("public void write" + m.getName() + "XMLExportToFile(File target) throws IOException, ASGRuntimeException{");
            this.increaseIdent();
            this.appendStatement("writeToFile(create" + m.getName() + "XMLExport(), target)");
            this.append(this.closeBlock());
            XMLImporterGenerator.emptyline();
        }
        this.appendString("private void writeToFile(XMLTree tree, File target) throws IOException{");
        this.increaseIdent();
        this.appendStatement("FileOutputStream fOut = null");
        this.appendString("try{");
        this.increaseIdent();
        this.appendStatement("fOut = new FileOutputStream(target)");
        this.appendStatement("XMLWriter writer = new XMLWriter()");
        this.appendStatement("OutputStreamWriter oWriter = writer.write(tree, fOut)");
        this.appendStatement("oWriter.close()");
        this.decreaseIdent();
        this.appendStatement("}catch(IOException e){");
        this.increaseIdent();
        this.appendString("if (fOut!=null){");
        this.increaseIdent();
        this.appendString("try{");
        this.appendIncreasedStatement("fOut.close()");
        this.appendString("}catch(IOException ignored){}");
        this.append(this.closeBlock());
        this.appendStatement("throw e");
        this.append(this.closeBlock());
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        this.appendString("private XMLTree createExport(List<XMLNode> nodes){");
        this.increaseIdent();
        this.appendStatement("XMLTree tree = new XMLTree()");
        this.appendStatement("tree.setEncoding(" + this.quote(GeneratorDataRegistry.getInstance().getContext().getEncoding()) + ")");
        this.appendStatement("XMLNode root = new XMLNode(" + this.quote("export") + ")");
        this.appendStatement("root.addAttribute(new XMLAttribute(" + this.quote("timestamp") + ", \"\"+System.currentTimeMillis()))");
        this.appendStatement("root.addAttribute(new XMLAttribute(" + this.quote("date") + ", Date.currentDate().toString()))");
        this.appendStatement("tree.setRoot(root)");
        this.appendStatement("root.setChildren(nodes)");
        this.appendStatement("return tree");
        this.append(this.closeBlock());
        XMLImporterGenerator.emptyline();
        this.appendString("public static void main(String[] a) throws IOException,ASGRuntimeException{");
        this.increaseIdent();
        this.appendStatement("new " + XMLImporterGenerator.getImporterClassName(context) + "().writeCompleteXMLExportToFile(new File(" + this.quote(context.getApplicationName() + "_export.xml") + "))");
        this.append(this.closeBlock());
        return new FileEntry(clazz);
    }
}

