/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anotheria.asg.generator.IGenerateable;
import net.anotheria.asg.generator.meta.MetaContainerProperty;
import net.anotheria.asg.generator.meta.MetaLink;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;

public class MetaDocument
implements IGenerateable {
    private String name;
    private List<MetaProperty> properties;
    private List<MetaProperty> links;
    private Set<String> propertyNames;
    private MetaModule parentModule;

    public MetaDocument(String aName) {
        this.name = aName;
        this.properties = new ArrayList<MetaProperty>();
        this.links = new ArrayList<MetaProperty>();
        this.propertyNames = new HashSet<String>();
    }

    public void addProperty(MetaProperty p) {
        if (this.propertyNames.contains(p.getName())) {
            throw new IllegalArgumentException("This document already contains a property or link with name " + p.getName());
        }
        this.propertyNames.add(p.getName());
        this.properties.add(p);
    }

    public void addLink(MetaLink l) {
        if (this.propertyNames.contains(l.getName())) {
            throw new IllegalArgumentException("This document already contains a property or link with name " + l.getName());
        }
        this.propertyNames.add(l.getName());
        this.links.add(l);
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean multiple) {
        return multiple ? this.getMultiple() : this.getName();
    }

    public List<MetaProperty> getProperties() {
        return this.properties;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "D " + this.name + " " + this.properties;
    }

    public String getListName() {
        return "LIST_" + this.getName().toUpperCase();
    }

    public String getListConstantValue() {
        return "list_" + this.getName().toLowerCase();
    }

    public String getMultiple() {
        return this.getName() + "s";
    }

    public String getTemporaryVariableName() {
        return "tmp_" + this.getVariableName();
    }

    public String getVariableName() {
        if (this.getName().length() < 3) {
            return "" + this.getName().toLowerCase().charAt(0);
        }
        Object vName = this.getName().toLowerCase();
        if (((String)vName).equals("new") || ((String)vName).equals("int")) {
            vName = "_" + (String)vName;
        }
        return vName;
    }

    public List<MetaProperty> getLinks() {
        return this.links;
    }

    public String getIdHolderName() {
        return "ID_HOLDER_" + this.getName().toUpperCase();
    }

    public MetaProperty getField(String name) {
        if (name.equals("id")) {
            return new MetaProperty("id", MetaProperty.Type.STRING);
        }
        if (name.equals("plainId")) {
            return new MetaProperty("plainId", MetaProperty.Type.STRING);
        }
        if (name.equals("documentLastUpdateTimestamp")) {
            return new MetaProperty("documentLastUpdateTimestamp", MetaProperty.Type.STRING);
        }
        if (name.equals("multilingualInstanceDisabled")) {
            return new MetaProperty("multilingualInstanceDisabled", MetaProperty.Type.BOOLEAN);
        }
        for (MetaProperty p : this.properties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        for (MetaProperty p : this.links) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        throw new IllegalArgumentException("No such field: " + name + " in document " + this.getFullName());
    }

    public boolean isComparable() {
        int i;
        for (i = 0; i < this.properties.size(); ++i) {
            if (this.properties.get(i) instanceof MetaContainerProperty) continue;
            return true;
        }
        for (i = 0; i < this.links.size(); ++i) {
            if (this.links.get(i) instanceof MetaContainerProperty) continue;
            return true;
        }
        return false;
    }

    public String getFullName() {
        return this.getParentModule() == null ? "?." + this.getName() : this.getParentModule().getName() + "." + this.getName();
    }

    public MetaModule getParentModule() {
        return this.parentModule;
    }

    public void setParentModule(MetaModule parentModule) {
        this.parentModule = parentModule;
    }

    public List<MetaLink> getLinksToDocument(MetaDocument anotherDocument) {
        ArrayList<MetaLink> ret = new ArrayList<MetaLink>();
        for (MetaProperty p : this.links) {
            MetaLink l = (MetaLink)p;
            if (!l.doesTargetMatch(anotherDocument)) continue;
            ret.add(l);
        }
        return ret;
    }

    public boolean isMultilingual() {
        for (MetaProperty p : this.properties) {
            if (!p.isMultilingual()) continue;
            return true;
        }
        for (MetaProperty p : this.links) {
            if (!p.isMultilingual()) continue;
            return true;
        }
        return false;
    }
}

