/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.asg.generator.meta.FederatedDocumentMapping;
import net.anotheria.asg.generator.meta.FederatedModuleDef;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.StorageType;

public class MetaFederationModule
extends MetaModule {
    private List<FederatedModuleDef> federatedModules;
    private Map<String, List<FederatedDocumentMapping>> mappings;

    public MetaFederationModule() {
        this(null);
    }

    public MetaFederationModule(String name) {
        super(name);
        this.setStorageType(StorageType.FEDERATION);
        this.federatedModules = new ArrayList<FederatedModuleDef>();
        this.mappings = new HashMap<String, List<FederatedDocumentMapping>>();
    }

    public void addFederatedModule(String aKey, String aName) {
        this.federatedModules.add(new FederatedModuleDef(aKey, aName));
    }

    public List<FederatedModuleDef> getFederatedModules() {
        return this.federatedModules;
    }

    public void setFederatedModules(List<FederatedModuleDef> federatedModules) {
        this.federatedModules = federatedModules;
    }

    public void addMapping(FederatedDocumentMapping mapping) {
        List<FederatedDocumentMapping> mappingsForDocument = this.mappings.get(mapping.getSourceDocument());
        if (mappingsForDocument == null) {
            mappingsForDocument = new ArrayList<FederatedDocumentMapping>();
            this.mappings.put(mapping.getSourceDocument(), mappingsForDocument);
        }
        mappingsForDocument.add(mapping);
    }

    public List<FederatedDocumentMapping> getMappingsForDocument(String documentName) {
        ArrayList ret = this.mappings.get(documentName);
        return ret == null ? new ArrayList() : ret;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

