/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.generator.meta;

import java.util.List;
import net.anotheria.asg.generator.meta.MetaDocument;
import net.anotheria.asg.generator.meta.MetaModule;
import net.anotheria.asg.generator.meta.MetaProperty;

public class MetaLink
extends MetaProperty {
    private String linkType;
    private String linkTarget;
    private List<String> linkDecoration;

    public MetaLink(String name) {
        super(name, MetaProperty.Type.STRING);
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkTarget(String string) {
        this.linkTarget = string;
    }

    public void setLinkType(String string) {
        this.linkType = string;
    }

    @Override
    public String toNameConstant() {
        return "LINK_" + super.toNameConstant();
    }

    @Override
    public boolean isLinked() {
        return true;
    }

    public String getTargetModuleName() {
        int index = this.getLinkTarget().indexOf(46);
        return index == -1 ? null : this.getLinkTarget().substring(0, index);
    }

    public String getTargetDocumentName() {
        return this.getLinkTarget().substring(this.getLinkTarget().indexOf(46) + 1);
    }

    public boolean doesTargetMatch(MetaDocument document) {
        return this.doesTargetMath(document.getParentModule(), document);
    }

    public boolean doesTargetMath(MetaModule module, MetaDocument document) {
        return this.linkTarget != null && this.linkTarget.equals(module.getName() + "." + document.getName());
    }

    public boolean isRelative() {
        return this.getLinkTarget().indexOf(46) == -1;
    }

    public List<String> getLinkDecoration() {
        return this.linkDecoration;
    }

    public void setLinkDecoration(List<String> linkDecoration) {
        this.linkDecoration = linkDecoration;
    }
}

